/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class LifoSetQueue<E>
extends AbstractQueue<E>
implements Queue<E> {
    private final ArrayList<E> lifo = new ArrayList();
    private final HashSet<E> set = new HashSet();

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.set.add(e)) {
            this.lifo.add(e);
        }
        return true;
    }

    @Override
    public E poll() {
        int size = this.lifo.size();
        if (size > 0) {
            E element = this.lifo.remove(size - 1);
            this.set.remove(element);
            return element;
        }
        return null;
    }

    @Override
    public E peek() {
        int size = this.lifo.size();
        if (size > 0) {
            return this.lifo.get(size - 1);
        }
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int currentPos;
            private int posToRemove;
            {
                this.currentPos = LifoSetQueue.this.lifo.size() - 1;
                this.posToRemove = -1;
            }

            @Override
            public boolean hasNext() {
                return this.currentPos >= 0;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.posToRemove = this.currentPos;
                return LifoSetQueue.this.lifo.get(this.currentPos--);
            }

            @Override
            public void remove() {
                if (this.posToRemove == -1) {
                    throw new NoSuchElementException();
                }
                Object element = LifoSetQueue.this.lifo.remove(this.posToRemove);
                LifoSetQueue.this.set.remove(element);
            }
        };
    }

    @Override
    public int size() {
        return this.lifo.size();
    }
}

