/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmaster.ExecutionSlotAllocator;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestEffortExecutionSlotAllocator
implements ExecutionSlotAllocator {
    static final Logger LOG = LoggerFactory.getLogger(BestEffortExecutionSlotAllocator.class);
    private final SlotProvider slotProvider;
    private final boolean allowQueuedScheduling;

    public BestEffortExecutionSlotAllocator(SlotProvider slotProvider, boolean allowQueuedScheduling) {
        this.slotProvider = slotProvider;
        this.allowQueuedScheduling = allowQueuedScheduling;
    }

    @Override
    public CompletableFuture<Collection<LogicalSlot>> allocateSlotsFor(Collection<Execution> executions, Time allocationTimeout) {
        boolean queued = this.allowQueuedScheduling;
        ArrayList<SlotRequestId> slotRequestIds = new ArrayList<SlotRequestId>(executions.size());
        ArrayList<ScheduledUnit> scheduledUnits = new ArrayList<ScheduledUnit>(executions.size());
        ArrayList<SlotProfile> slotProfiles = new ArrayList<SlotProfile>(executions.size());
        ArrayList<Execution> scheduledExecutions = new ArrayList<Execution>(executions.size());
        for (Execution exec : executions) {
            Tuple2<ScheduledUnit, SlotProfile> scheduleUnitAndSlotProfile = exec.prepareSchedulingResources();
            slotRequestIds.add(new SlotRequestId());
            scheduledUnits.add((ScheduledUnit)scheduleUnitAndSlotProfile.f0);
            slotProfiles.add((SlotProfile)scheduleUnitAndSlotProfile.f1);
            scheduledExecutions.add(exec);
        }
        if (slotRequestIds.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        LOG.info("Request {} slots in a group.", (Object)slotRequestIds.size());
        List<CompletableFuture<LogicalSlot>> allocationFutures = this.slotProvider.allocateSlots(slotRequestIds, scheduledUnits, queued, slotProfiles, allocationTimeout);
        for (int i = 0; i < allocationFutures.size(); ++i) {
            int index = i;
            allocationFutures.get(i).whenComplete((ignore, throwable) -> {
                if (throwable != null) {
                    this.slotProvider.cancelSlotRequest((SlotRequestId)((Object)((Object)slotRequestIds.get(index))), ((ScheduledUnit)scheduledUnits.get(index)).getSlotSharingGroupId(), ((ScheduledUnit)scheduledUnits.get(index)).getCoLocationConstraint(), (Throwable)throwable);
                }
            });
        }
        FutureUtils.ConjunctFuture<Collection<LogicalSlot>> allAllocationFutures = FutureUtils.combineAllInOrder(allocationFutures);
        CompletionStage returnFuture = allAllocationFutures.handle((slots, throwable) -> {
            if (throwable != null) {
                LOG.info("Batch request {} slots, but only {} are fulfilled.", new Object[]{allAllocationFutures.getNumFuturesTotal(), allAllocationFutures.getNumFuturesCompleted(), throwable});
                ArrayList returnSlots = new ArrayList(allocationFutures.size());
                for (int i = 0; i < allocationFutures.size(); ++i) {
                    if (((CompletableFuture)allocationFutures.get(i)).completeExceptionally((Throwable)throwable)) {
                        returnSlots.add(i, null);
                        continue;
                    }
                    try {
                        returnSlots.add(i, ((CompletableFuture)allocationFutures.get(i)).get());
                        continue;
                    }
                    catch (Exception e) {
                        returnSlots.add(i, null);
                    }
                }
                return returnSlots;
            }
            return slots;
        });
        ((CompletableFuture)returnFuture).exceptionally(throwable -> {
            if (throwable instanceof CancellationException) {
                for (int i = 0; i < allocationFutures.size(); ++i) {
                    if (((CompletableFuture)allocationFutures.get(i)).completeExceptionally((Throwable)throwable)) continue;
                    try {
                        LogicalSlot slot = (LogicalSlot)((CompletableFuture)allocationFutures.get(i)).get();
                        if (slot == null) continue;
                        slot.releaseSlot((Throwable)throwable);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
            throw new CompletionException((Throwable)throwable);
        });
        return returnFuture;
    }
}

