/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.StackTrace;
import org.apache.flink.runtime.messages.StackTraceSampleResponse;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.util.Preconditions;

public class RpcTaskManagerGateway
implements TaskManagerGateway {
    private final TaskExecutorGateway taskExecutorGateway;
    private final JobMasterId jobMasterId;

    public RpcTaskManagerGateway(TaskExecutorGateway taskExecutorGateway, JobMasterId jobMasterId) {
        this.taskExecutorGateway = (TaskExecutorGateway)Preconditions.checkNotNull((Object)taskExecutorGateway);
        this.jobMasterId = (JobMasterId)((Object)Preconditions.checkNotNull((Object)((Object)jobMasterId)));
    }

    @Override
    public String getAddress() {
        return this.taskExecutorGateway.getAddress();
    }

    @Override
    public void disconnectFromJobManager(InstanceID instanceId, Exception cause) {
        throw new UnsupportedOperationException("Operation is not yet supported.");
    }

    @Override
    public void stopCluster(ApplicationStatus applicationStatus, String message) {
        throw new UnsupportedOperationException("Operation is not yet supported.");
    }

    @Override
    public CompletableFuture<StackTrace> requestStackTrace(Time timeout) {
        throw new UnsupportedOperationException("Operation is not yet supported.");
    }

    @Override
    public CompletableFuture<StackTraceSampleResponse> requestStackTraceSample(ExecutionAttemptID executionAttemptID, int sampleId, int numSamples, Time delayBetweenSamples, int maxStackTraceDepth, Time timeout) {
        return this.taskExecutorGateway.requestStackTraceSample(executionAttemptID, sampleId, numSamples, delayBetweenSamples, maxStackTraceDepth, timeout);
    }

    @Override
    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, Time timeout) {
        return this.taskExecutorGateway.submitTask(tdd, this.jobMasterId, timeout);
    }

    @Override
    public CompletableFuture<Acknowledge> stopTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        return this.taskExecutorGateway.stopTask(executionAttemptID, timeout);
    }

    @Override
    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        return this.taskExecutorGateway.cancelTask(executionAttemptID, timeout);
    }

    @Override
    public CompletableFuture<Acknowledge> updatePartitions(ExecutionAttemptID executionAttemptID, Iterable<PartitionInfo> partitionInfos, Time timeout) {
        return this.taskExecutorGateway.updatePartitions(executionAttemptID, partitionInfos, timeout);
    }

    @Override
    public void failPartition(ExecutionAttemptID executionAttemptID) {
        this.taskExecutorGateway.failPartition(executionAttemptID);
    }

    @Override
    public void notifyCheckpointComplete(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp) {
        this.taskExecutorGateway.confirmCheckpoint(executionAttemptID, checkpointId, timestamp);
    }

    @Override
    public void notifyCheckpointSubsume(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp) {
        this.taskExecutorGateway.subsumeCheckpoint(executionAttemptID, checkpointId, timestamp);
    }

    @Override
    public void notifyCheckpointAbort(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp) {
        this.taskExecutorGateway.abortCheckpoint(executionAttemptID, checkpointId, timestamp);
    }

    @Override
    public void triggerCheckpoint(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp, CheckpointOptions checkpointOptions, boolean advanceToEndOfTime) {
        this.taskExecutorGateway.triggerCheckpoint(executionAttemptID, checkpointId, timestamp, checkpointOptions, advanceToEndOfTime);
    }

    @Override
    public CompletableFuture<TransientBlobKey> requestTaskManagerLog(Time timeout) {
        return this.taskExecutorGateway.requestFileUpload("taskmanager.log", null, timeout);
    }

    @Override
    public CompletableFuture<TransientBlobKey> requestTaskManagerStdout(Time timeout) {
        return this.taskExecutorGateway.requestFileUpload("taskmanager.out", null, timeout);
    }

    @Override
    public CompletableFuture<Acknowledge> freeSlot(AllocationID allocationId, Throwable cause, Time timeout) {
        return this.taskExecutorGateway.freeSlot(allocationId, cause, timeout);
    }
}

