/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.MathUtils;

public class TaskNetworkMemoryUtil {
    public static int calculateTaskNetworkMemory(Configuration configuration, int subPartitionNum, int internalResultPartitionNum, int pipelineInputChannelNum, int pipelineInputGateNum, int blockingInputChannelNum, int blockingInputGateNum) {
        int pageSize = configuration.getInteger(TaskManagerOptions.MEMORY_SEGMENT_SIZE);
        int buffersPerPipelineChannel = configuration.getInteger(TaskManagerOptions.NETWORK_BUFFERS_PER_CHANNEL);
        int buffersPerSubpartition = configuration.getInteger(TaskManagerOptions.NETWORK_BUFFERS_PER_SUBPARTITION);
        int extraBuffersPerPipelineGate = configuration.getInteger(TaskManagerOptions.NETWORK_EXTRA_BUFFERS_PER_GATE);
        int buffersPerBlockingChannel = configuration.getInteger(TaskManagerOptions.NETWORK_BUFFERS_PER_EXTERNAL_BLOCKING_CHANNEL);
        int extraBuffersPerBlockingGate = configuration.getInteger(TaskManagerOptions.NETWORK_EXTRA_BUFFERS_PER_EXTERNAL_BLOCKING_GATE);
        int extraBuffersAllPipelineGates = extraBuffersPerPipelineGate >= 0 ? extraBuffersPerPipelineGate * pipelineInputGateNum : buffersPerPipelineChannel * pipelineInputChannelNum;
        int extraBuffersAllBlockingGates = Math.max(extraBuffersPerBlockingGate, 0) * blockingInputGateNum;
        int extraBuffersAllResultPartitions = extraBuffersPerPipelineGate >= 0 ? extraBuffersPerPipelineGate * internalResultPartitionNum : buffersPerSubpartition * subPartitionNum;
        long totalBuffers = pipelineInputChannelNum * buffersPerPipelineChannel + extraBuffersAllPipelineGates + blockingInputChannelNum * buffersPerBlockingChannel + extraBuffersAllBlockingGates + subPartitionNum * buffersPerSubpartition + extraBuffersAllResultPartitions;
        long memoryInMbLong = (long)Math.ceil((double)((long)pageSize * totalBuffers) / 1048576.0);
        return MathUtils.checkedDownCast((long)memoryInMbLong);
    }
}

