/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.failover;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.jobmaster.failover.DummyOperationLogStore;
import org.apache.flink.runtime.jobmaster.failover.FileSystemOperationLogStore;
import org.apache.flink.runtime.jobmaster.failover.MemoryOperationLogStore;
import org.apache.flink.runtime.jobmaster.failover.OperationLogStore;

public class OperationLogStoreLoader {
    public static OperationLogStore loadOperationLogStore(JobID jobID, Configuration config) {
        String storeParam = config.getString(JobManagerOptions.OPERATION_LOG_STORE);
        switch (storeParam.toLowerCase()) {
            case "dummy": {
                return new DummyOperationLogStore();
            }
            case "memory": {
                return new MemoryOperationLogStore();
            }
            case "filesystem": {
                return new FileSystemOperationLogStore(jobID, config);
            }
        }
        return new DummyOperationLogStore();
    }
}

