/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.message;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class PendingSlotRequest
implements Serializable {
    private static final long serialVersionUID = 5448945800436094025L;
    private final SlotRequestId slotRequestId;
    private final ResourceProfile resourceProfile;
    private final long startTimestamp;
    private final List<PendingScheduledUnit> pendingScheduledUnits;

    public PendingSlotRequest(SlotRequestId slotRequestId, ResourceProfile resourceProfile, long startTimestamp, List<PendingScheduledUnit> pendingScheduledUnits) {
        this.slotRequestId = slotRequestId;
        this.pendingScheduledUnits = pendingScheduledUnits;
        this.resourceProfile = resourceProfile;
        this.startTimestamp = startTimestamp;
    }

    public SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public List<PendingScheduledUnit> getPendingScheduledUnits() {
        return this.pendingScheduledUnits;
    }

    public static class PendingScheduledUnit
    implements Serializable {
        private static final long serialVersionUID = 8348131373293816273L;
        private final JobVertexID jobVertexId;
        @Nullable
        private final SlotSharingGroupId slotSharingGroupId;
        @Nullable
        private final AbstractID coLocationGroupId;
        private final String taskName;
        private final int subTaskIndex;
        private final int subTaskAttempt;

        public PendingScheduledUnit(JobVertexID jobVertexId, @Nullable SlotSharingGroupId slotSharingGroupId, @Nullable AbstractID coLocationGroupId, String taskName, int subTaskIndex, int subTaskAttempt) {
            this.jobVertexId = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexId)));
            this.slotSharingGroupId = slotSharingGroupId;
            this.coLocationGroupId = coLocationGroupId;
            this.taskName = taskName;
            this.subTaskIndex = subTaskIndex;
            this.subTaskAttempt = subTaskAttempt;
        }

        public static PendingScheduledUnit of(ScheduledUnit scheduledUnit) {
            CoLocationConstraint coLocationConstraint = scheduledUnit.getCoLocationConstraint();
            Execution subTask = scheduledUnit.getTaskToExecute();
            return new PendingScheduledUnit(scheduledUnit.getJobVertexId(), scheduledUnit.getSlotSharingGroupId(), coLocationConstraint != null ? coLocationConstraint.getGroup().getId() : null, subTask.getVertex().getTaskName(), subTask.getParallelSubtaskIndex(), subTask.getAttemptNumber());
        }

        public JobVertexID getJobVertexId() {
            return this.jobVertexId;
        }

        @Nullable
        public SlotSharingGroupId getSlotSharingGroupId() {
            return this.slotSharingGroupId;
        }

        @Nullable
        public AbstractID getCoLocationGroupId() {
            return this.coLocationGroupId;
        }

        public int getSubTaskIndex() {
            return this.subTaskIndex;
        }

        public int getSubTaskAttempt() {
            return this.subTaskAttempt;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String toString() {
            return "{task={subTaskIndex=" + this.subTaskIndex + ", subTaskAttempt=" + this.subTaskAttempt + "}, sharingUnit=" + (Object)((Object)this.slotSharingGroupId) + ", coLocationGroupId=" + this.coLocationGroupId + '}';
        }
    }
}

