/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.standalone.TaskManagerResourceCalculator;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.TaskManagerResource;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.runtime.resourcemanager.slotmanager.DynamicAssigningSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;

public class StandaloneResourceManager
extends ResourceManager<ResourceID> {
    private final TaskManagerResource taskManagerResource;

    public StandaloneResourceManager(RpcService rpcService, String resourceManagerEndpointId, ResourceID resourceId, ResourceManagerConfiguration resourceManagerConfiguration, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, SlotManager slotManager, MetricRegistry metricRegistry, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler) {
        this(rpcService, resourceManagerEndpointId, resourceId, new Configuration(), resourceManagerConfiguration, highAvailabilityServices, heartbeatServices, slotManager, metricRegistry, jobLeaderIdService, clusterInformation, fatalErrorHandler);
    }

    public StandaloneResourceManager(RpcService rpcService, String resourceManagerEndpointId, ResourceID resourceId, Configuration configuration, ResourceManagerConfiguration resourceManagerConfiguration, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, SlotManager slotManager, MetricRegistry metricRegistry, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler) {
        super(rpcService, resourceManagerEndpointId, resourceId, resourceManagerConfiguration, highAvailabilityServices, heartbeatServices, slotManager, metricRegistry, jobLeaderIdService, clusterInformation, fatalErrorHandler);
        this.taskManagerResource = TaskManagerResource.fromConfiguration(configuration, TaskManagerResourceCalculator.initContainerResourceConfig(configuration), 1);
        this.log.info(this.taskManagerResource.toString());
        if (slotManager instanceof DynamicAssigningSlotManager) {
            ((DynamicAssigningSlotManager)slotManager).setTotalResourceOfTaskExecutor(this.taskManagerResource.getTaskResourceProfile());
            this.log.info("TaskExecutors should be started with JVM heap size {} MB, new generation size {} MB, JVM direct memory limit {} MB", new Object[]{this.taskManagerResource.getTotalHeapMemory(), this.taskManagerResource.getYoungHeapMemory(), this.taskManagerResource.getTotalDirectMemory()});
        } else {
            this.log.warn("DynamicAssigningSlotManager have not been set in StandaloneResourceManager, setResources() of operator may not work!");
        }
    }

    @Override
    protected void initialize() throws ResourceManagerException {
    }

    @Override
    protected void internalDeregisterApplication(ApplicationStatus finalStatus, @Nullable String diagnostics) {
    }

    @Override
    public void startNewWorker(ResourceProfile resourceProfile) {
    }

    @Override
    public void startNewWorker(ResourceProfile resourceProfile, Set<SlotTag> tags) {
    }

    @Override
    public void startNewWorkers(List<ResourceProfile> resourceProfiles, List<Set<SlotTag>> slotsTags) {
    }

    @Override
    public boolean stopWorker(ResourceID resourceID) {
        return false;
    }

    @Override
    public void cancelNewWorker(ResourceProfile resourceProfile) {
    }

    @Override
    public void cancelNewWorker(ResourceProfile resourceProfile, Set<SlotTag> tags) {
    }

    @Override
    protected int getNumberAllocatedWorkers() {
        return 0;
    }

    @Override
    protected ResourceID workerStarted(ResourceID resourceID) {
        return resourceID;
    }
}

