/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.placementconstraint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.resourcemanager.placementconstraint.PlacementConstraint;
import org.apache.flink.runtime.resourcemanager.placementconstraint.PlacementConstraintID;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.runtime.resourcemanager.placementconstraint.TaggedSlot;

public class PlacementConstraintManager {
    private final Map<PlacementConstraintID, PlacementConstraint> placementConstraintTable = new HashMap<PlacementConstraintID, PlacementConstraint>();
    private final Map<JobID, Set<PlacementConstraintID>> jobConstraintIndex = new HashMap<JobID, Set<PlacementConstraintID>>();
    private final Map<String, Set<PlacementConstraintID>> withTagNameConstraintIndex = new HashMap<String, Set<PlacementConstraintID>>();
    private final Map<String, Set<PlacementConstraintID>> withoutTagNameConstraintIndex = new HashMap<String, Set<PlacementConstraintID>>();

    public synchronized void setJobConstraints(JobID jobId, List<PlacementConstraint> newConstraints) {
        if (this.jobConstraintIndex.containsKey(jobId)) {
            for (PlacementConstraintID pcid : this.jobConstraintIndex.get(jobId)) {
                this.placementConstraintTable.remove(pcid);
            }
        }
        this.jobConstraintIndex.put(jobId, new HashSet());
        for (PlacementConstraint constraint : newConstraints) {
            PlacementConstraintID pcid = PlacementConstraintID.generate();
            this.placementConstraintTable.put(pcid, constraint);
            this.jobConstraintIndex.get(jobId).add(pcid);
            TaggedSlot slot = constraint.getSlot();
            if (slot.isWithTag()) {
                for (SlotTag tag : slot.getTags()) {
                    if (!this.withTagNameConstraintIndex.containsKey(tag.getTagName())) {
                        this.withTagNameConstraintIndex.put(tag.getTagName(), new HashSet());
                    }
                    this.withTagNameConstraintIndex.get(tag.getTagName()).add(pcid);
                }
                continue;
            }
            for (SlotTag tag : slot.getTags()) {
                if (!this.withoutTagNameConstraintIndex.containsKey(tag.getTagName())) {
                    this.withoutTagNameConstraintIndex.put(tag.getTagName(), new HashSet());
                }
                this.withoutTagNameConstraintIndex.get(tag.getTagName()).add(pcid);
            }
        }
    }

    public synchronized boolean check(JobID jobId, List<SlotTag> slotTags, List<List<SlotTag>> taskExecutorTags) {
        HashSet<PlacementConstraint> relatedConstraints = new HashSet<PlacementConstraint>();
        for (SlotTag tag : slotTags) {
            if (!this.withTagNameConstraintIndex.containsKey(tag.getTagName())) continue;
            Set<PlacementConstraintID> withTagConstraintIds = this.withTagNameConstraintIndex.get(tag.getTagName());
            Iterator<PlacementConstraintID> iterator = withTagConstraintIds.iterator();
            while (iterator.hasNext()) {
                PlacementConstraintID pcid = iterator.next();
                if (!this.placementConstraintTable.containsKey(pcid)) {
                    iterator.remove();
                    continue;
                }
                relatedConstraints.add(this.placementConstraintTable.get(pcid));
            }
            if (!withTagConstraintIds.isEmpty()) continue;
            this.withTagNameConstraintIndex.remove(tag.getTagName());
        }
        for (String tagName : this.withoutTagNameConstraintIndex.keySet()) {
            SlotTag tag = new SlotTag(tagName, jobId);
            if (slotTags.contains(tag)) continue;
            Set<PlacementConstraintID> withoutTagConstraintIds = this.withoutTagNameConstraintIndex.get(tag.getTagName());
            Iterator<PlacementConstraintID> iterator = withoutTagConstraintIds.iterator();
            while (iterator.hasNext()) {
                PlacementConstraintID pcid = iterator.next();
                if (!this.placementConstraintTable.containsKey(pcid)) {
                    iterator.remove();
                    continue;
                }
                relatedConstraints.add(this.placementConstraintTable.get(pcid));
            }
            if (!withoutTagConstraintIds.isEmpty()) continue;
            this.withoutTagNameConstraintIndex.remove(tag.getTagName());
        }
        for (PlacementConstraint pc : relatedConstraints) {
            if (!pc.applyTo(slotTags) || pc.check(taskExecutorTags)) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean hasPlacementConstraints(JobID jobID) {
        return this.jobConstraintIndex.containsKey(jobID) && !this.jobConstraintIndex.get(jobID).isEmpty();
    }
}

