/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.placementconstraint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTagScope;

public class TaggedSlot
implements Serializable {
    private final boolean withTag;
    private final List<SlotTag> tags;
    private final SlotTagScope scope;

    public TaggedSlot(boolean withTag, List<SlotTag> tags, SlotTagScope scope) {
        this.withTag = withTag;
        this.tags = new ArrayList<SlotTag>(tags);
        this.scope = scope;
    }

    public boolean isWithTag() {
        return this.withTag;
    }

    public List<SlotTag> getTags() {
        return this.tags;
    }

    public boolean matchSlotWithTags(List<SlotTag> tags) {
        if (this.withTag) {
            for (SlotTag tag1 : this.tags) {
                for (SlotTag tag2 : tags) {
                    if (!tag1.match(tag2, this.scope)) continue;
                    return true;
                }
            }
            return false;
        }
        for (SlotTag tag1 : this.tags) {
            for (SlotTag tag2 : tags) {
                if (!tag1.match(tag2, this.scope)) continue;
                return false;
            }
        }
        return true;
    }
}

