/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.placementconstraint;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.runtime.resourcemanager.placementconstraint.TaggedSlot;

public class TaggedSlotContext
implements Serializable {
    private final boolean containSlot;
    private final TaggedSlot slot;

    public TaggedSlotContext(boolean containSlot, TaggedSlot slot) {
        this.containSlot = containSlot;
        this.slot = slot;
    }

    public boolean isContainSlot() {
        return this.containSlot;
    }

    public TaggedSlot getSlot() {
        return this.slot;
    }

    public boolean matchContextWithTags(List<List<SlotTag>> contextTags) {
        if (this.containSlot) {
            for (List<SlotTag> slotTags : contextTags) {
                if (!this.slot.matchSlotWithTags(slotTags)) continue;
                return true;
            }
            return false;
        }
        for (List<SlotTag> slotTags : contextTags) {
            if (!this.slot.matchSlotWithTags(slotTags)) continue;
            return false;
        }
        return true;
    }
}

