/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.Duration;

public class SlotManagerConfiguration {
    private final Time taskManagerRequestTimeout;
    private final Time slotRequestTimeout;
    private final Time taskManagerTimeout;
    private final Time taskManagerFastTimeout;
    private final Time taskManagerCheckerInitialDelay;

    public SlotManagerConfiguration(Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout, Time taskManagerFastTimeout, Time taskManagerCheckerInitialDelay) {
        this.taskManagerRequestTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerRequestTimeout);
        this.slotRequestTimeout = (Time)Preconditions.checkNotNull((Object)slotRequestTimeout);
        this.taskManagerTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerTimeout);
        this.taskManagerFastTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerFastTimeout);
        this.taskManagerCheckerInitialDelay = (Time)Preconditions.checkNotNull((Object)taskManagerCheckerInitialDelay);
    }

    public Time getTaskManagerRequestTimeout() {
        return this.taskManagerRequestTimeout;
    }

    public Time getSlotRequestTimeout() {
        return this.slotRequestTimeout;
    }

    public Time getTaskManagerTimeout() {
        return this.taskManagerTimeout;
    }

    public Time getTaskManagerFastTimeout() {
        return this.taskManagerFastTimeout;
    }

    public Time getTaskManagerCheckerInitialDelay() {
        return this.taskManagerCheckerInitialDelay;
    }

    public static SlotManagerConfiguration fromConfiguration(Configuration configuration) throws ConfigurationException {
        Time rpcTimeout;
        String strTimeout = configuration.getString(AkkaOptions.ASK_TIMEOUT);
        try {
            rpcTimeout = Time.milliseconds((long)Duration.apply((String)strTimeout).toMillis());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Could not parse the resource manager's timeout value " + AkkaOptions.ASK_TIMEOUT + '.', (Throwable)e);
        }
        Time slotRequestTimeout = Time.milliseconds((long)configuration.getLong(ResourceManagerOptions.SLOT_REQUEST_TIMEOUT));
        Time taskManagerTimeout = Time.milliseconds((long)configuration.getLong(ResourceManagerOptions.TASK_MANAGER_TIMEOUT));
        Time taskManagerFastTimeout = Time.milliseconds((long)configuration.getLong(ResourceManagerOptions.TASK_MANAGER_FAST_TIMEOUT));
        Time taskManagerCheckerInitialDelay = Time.milliseconds((long)configuration.getLong(ResourceManagerOptions.TASK_MANAGER_CHECKER_INITIAL_DELAY));
        return new SlotManagerConfiguration(rpcTimeout, slotRequestTimeout, taskManagerTimeout, taskManagerFastTimeout, taskManagerCheckerInitialDelay);
    }
}

