/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.TotalResourceLimitExceptionsInfos;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class TotalResourceLimitExceptionsHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, TotalResourceLimitExceptionsInfos, EmptyMessageParameters> {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;

    public TotalResourceLimitExceptionsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, TotalResourceLimitExceptionsInfos, EmptyMessageParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.resourceManagerGatewayRetriever = resourceManagerGatewayRetriever;
    }

    @Override
    protected CompletableFuture<TotalResourceLimitExceptionsInfos> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, EmptyMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        ResourceManagerGateway resourceManagerGateway = this.getResourceManagerGateway(this.resourceManagerGatewayRetriever);
        return resourceManagerGateway.requestTotalResourceLimitExceptions(this.timeout).thenApply(TotalResourceLimitExceptionsInfos::new);
    }
}

