/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphsHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsEndFilterQueryParameter;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsStartFilterQueryParameter;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.apache.flink.runtime.util.FixedSortedSet;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobExceptionsHandler
extends AbstractExecutionGraphsHandler<JobExceptionsInfo, JobExceptionsMessageParameters>
implements JsonArchivist {
    static final int MAX_NUMBER_EXCEPTION_TO_REPORT = 200;

    public JobExceptionsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobExceptionsInfo, JobExceptionsMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected JobExceptionsInfo handleRequest(HandlerRequest<EmptyRequestBody, JobExceptionsMessageParameters> request, AccessExecutionGraph executionGraph, EvictingBoundedList<ArchivedExecutionGraph> historicalGraphs) {
        List startList = request.getQueryParameter(JobExceptionsStartFilterQueryParameter.class);
        List endList = request.getQueryParameter(JobExceptionsEndFilterQueryParameter.class);
        Long start2 = startList.isEmpty() ? Long.valueOf(-1L) : (Long)startList.get(0);
        Long end = endList.isEmpty() ? Long.valueOf(System.currentTimeMillis()) : (Long)endList.get(0);
        return JobExceptionsHandler.createJobExceptionsInfo(executionGraph, historicalGraphs, start2, end);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        JobExceptionsInfo json = JobExceptionsHandler.createJobExceptionsInfo(graph, null, -1L, System.currentTimeMillis());
        String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString());
        return Collections.singletonList(new ArchivedJson(path, json));
    }

    private static JobExceptionsInfo createJobExceptionsInfo(AccessExecutionGraph executionGraph, EvictingBoundedList<ArchivedExecutionGraph> historicalGraphs, Long start2, Long end) {
        ErrorInfo rootException = executionGraph.getFailureInfo();
        String rootExceptionMessage = null;
        Long rootTimestamp = null;
        if (rootException != null) {
            rootExceptionMessage = rootException.getExceptionAsString();
            rootTimestamp = rootException.getTimestamp();
        }
        FixedSortedSet taskExceptionList = new FixedSortedSet(200, Comparator.reverseOrder());
        int numExceptionsSofar = 0;
        boolean truncated = false;
        for (AccessExecutionJobVertex accessExecutionJobVertex : executionGraph.getVerticesTopologically()) {
            List<AccessExecutionJobVertex> vertexList = JobExceptionsHandler.getVertex(historicalGraphs, accessExecutionJobVertex);
            for (AccessExecutionJobVertex jobVertex : vertexList) {
                for (AccessExecutionVertex executionVertex : jobVertex.getTaskVertices()) {
                    AccessExecution task = executionVertex.getCurrentExecutionAttempt();
                    JobExceptionsInfo.ExecutionExceptionInfo executionExceptionInfo = JobExceptionsHandler.generateExecutionExceptionInfo(jobVertex, executionVertex, task);
                    if (executionExceptionInfo != null && executionExceptionInfo.getTimestamp() >= start2 && executionExceptionInfo.getTimestamp() <= end) {
                        taskExceptionList.add(executionExceptionInfo);
                        ++numExceptionsSofar;
                    }
                    for (int i = task.getAttemptNumber() - 1; i >= 0; --i) {
                        try {
                            task = executionVertex.getPriorExecutionAttempt(i);
                        }
                        catch (Exception e) {
                            break;
                        }
                        executionExceptionInfo = JobExceptionsHandler.generateExecutionExceptionInfo(jobVertex, executionVertex, task);
                        if (executionExceptionInfo == null || executionExceptionInfo.getTimestamp() < start2 || executionExceptionInfo.getTimestamp() > end) continue;
                        taskExceptionList.add(executionExceptionInfo);
                        ++numExceptionsSofar;
                    }
                    if (truncated || numExceptionsSofar < 200) continue;
                    truncated = true;
                }
            }
        }
        return new JobExceptionsInfo(rootExceptionMessage, rootTimestamp, new ArrayList<JobExceptionsInfo.ExecutionExceptionInfo>(taskExceptionList), truncated);
    }

    private static JobExceptionsInfo.ExecutionExceptionInfo generateExecutionExceptionInfo(AccessExecutionJobVertex jobVertex, AccessExecutionVertex executionVertex, AccessExecution task) {
        String t;
        String string = t = task != null ? task.getFailureCauseAsString() : null;
        if (t != null && !t.equals("(null)")) {
            TaskManagerLocation location = task.getAssignedResourceLocation();
            String locationString = location != null ? location.getFQDNHostname() + ':' + location.dataPort() : "(unassigned)";
            long timestamp = task.getStateTimestamp(ExecutionState.FAILED);
            return new JobExceptionsInfo.ExecutionExceptionInfo(t, executionVertex.getTaskNameWithSubtaskIndex(), locationString, timestamp == 0L ? -1L : timestamp, jobVertex.getJobVertexId().toString(), task.getParallelSubtaskIndex(), task.getAttemptNumber());
        }
        return null;
    }
}

