/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractSubtaskHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAllAttemptsInfo;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptInfo;
import org.apache.flink.runtime.rest.messages.job.SubtaskMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class SubtaskAllExecutionAttemptDetailsHandler
extends AbstractSubtaskHandler<SubtaskExecutionAllAttemptsInfo, SubtaskMessageParameters> {
    public SubtaskAllExecutionAttemptDetailsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, SubtaskExecutionAllAttemptsInfo, SubtaskMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected SubtaskExecutionAllAttemptsInfo handleRequest(HandlerRequest<EmptyRequestBody, SubtaskMessageParameters> request, AccessExecutionVertex executionVertex, String vertexId) throws RestHandlerException {
        AccessExecution execution = executionVertex.getCurrentExecutionAttempt();
        int currentAttemptNum = execution.getAttemptNumber();
        ArrayList<SubtaskExecutionAttemptInfo> allAttempts = new ArrayList<SubtaskExecutionAttemptInfo>();
        allAttempts.add(SubtaskExecutionAttemptInfo.create(execution, vertexId));
        if (currentAttemptNum > 0) {
            for (int i = currentAttemptNum - 1; i >= 0; --i) {
                AccessExecution currentExecution = executionVertex.getPriorExecutionAttempt(i);
                if (currentExecution == null) continue;
                allAttempts.add(SubtaskExecutionAttemptInfo.create(currentExecution, vertexId));
            }
        }
        return new SubtaskExecutionAllAttemptsInfo(allAttempts);
    }
}

