/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.checkpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.MinMaxAvgStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.checkpoints.AbstractCheckpointHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.MinMaxAvgStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.SubtaskCheckpointStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointMessageParameters;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatisticsWithSubtaskDetails;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class TaskCheckpointStatisticDetailsHandler
extends AbstractCheckpointHandler<TaskCheckpointStatisticsWithSubtaskDetails, TaskCheckpointMessageParameters>
implements JsonArchivist {
    public TaskCheckpointStatisticDetailsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, TaskCheckpointStatisticsWithSubtaskDetails, TaskCheckpointMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, CheckpointStatsCache checkpointStatsCache) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor, checkpointStatsCache);
    }

    @Override
    protected TaskCheckpointStatisticsWithSubtaskDetails handleCheckpointRequest(HandlerRequest<EmptyRequestBody, TaskCheckpointMessageParameters> request, AbstractCheckpointStats checkpointStats) throws RestHandlerException {
        JobVertexID jobVertexId = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        TaskStateStats taskStatistics = checkpointStats.getTaskStateStats(jobVertexId);
        if (taskStatistics == null) {
            throw new NotFoundException("There is no checkpoint statistics for task " + (Object)((Object)jobVertexId) + '.');
        }
        return TaskCheckpointStatisticDetailsHandler.createCheckpointDetails(checkpointStats, taskStatistics);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        CheckpointStatsSnapshot stats = graph.getCheckpointStatsSnapshot();
        if (stats == null) {
            return Collections.emptyList();
        }
        CheckpointStatsHistory history = stats.getHistory();
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(history.getCheckpoints().size());
        for (AbstractCheckpointStats checkpoint : history.getCheckpoints()) {
            for (TaskStateStats subtaskStats : checkpoint.getAllTaskStateStats()) {
                TaskCheckpointStatisticsWithSubtaskDetails json = TaskCheckpointStatisticDetailsHandler.createCheckpointDetails(checkpoint, subtaskStats);
                String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":vertexid", graph.getJobID().toString()).replace(":checkpointid", String.valueOf(checkpoint.getCheckpointId())).replace(":vertexid", subtaskStats.getJobVertexId().toString());
                archive.add(new ArchivedJson(path, json));
            }
        }
        return archive;
    }

    private static TaskCheckpointStatisticsWithSubtaskDetails createCheckpointDetails(AbstractCheckpointStats checkpointStats, TaskStateStats taskStatistics) {
        TaskCheckpointStatisticsWithSubtaskDetails.Summary summary = TaskCheckpointStatisticDetailsHandler.createSummary(taskStatistics.getSummaryStats(), checkpointStats.getTriggerTimestamp());
        List<SubtaskCheckpointStatistics> subtaskCheckpointStatistics = TaskCheckpointStatisticDetailsHandler.createSubtaskCheckpointStatistics(taskStatistics.getSubtaskStats(), checkpointStats.getTriggerTimestamp());
        return new TaskCheckpointStatisticsWithSubtaskDetails(checkpointStats.getCheckpointId(), checkpointStats.getStatus(), taskStatistics.getLatestAckTimestamp(), taskStatistics.getStateSize(), taskStatistics.getFullStateSize(), taskStatistics.getEndToEndDuration(checkpointStats.getTriggerTimestamp()), taskStatistics.getAlignmentBuffered(), taskStatistics.getNumberOfSubtasks(), taskStatistics.getNumberOfAcknowledgedSubtasks(), summary, subtaskCheckpointStatistics);
    }

    private static TaskCheckpointStatisticsWithSubtaskDetails.Summary createSummary(TaskStateStats.TaskStateStatsSummary taskStatisticsSummary, long triggerTimestamp) {
        MinMaxAvgStats stateSizeStats = taskStatisticsSummary.getStateSizeStats();
        MinMaxAvgStats ackTSStats = taskStatisticsSummary.getAckTimestampStats();
        MinMaxAvgStats syncDurationStats = taskStatisticsSummary.getSyncCheckpointDurationStats();
        MinMaxAvgStats asyncDurationStats = taskStatisticsSummary.getAsyncCheckpointDurationStats();
        TaskCheckpointStatisticsWithSubtaskDetails.CheckpointDuration checkpointDuration = new TaskCheckpointStatisticsWithSubtaskDetails.CheckpointDuration(new MinMaxAvgStatistics(syncDurationStats.getMinimum(), syncDurationStats.getMaximum(), syncDurationStats.getAverage()), new MinMaxAvgStatistics(asyncDurationStats.getMinimum(), asyncDurationStats.getMaximum(), asyncDurationStats.getAverage()));
        MinMaxAvgStats alignmentBufferedStats = taskStatisticsSummary.getAlignmentBufferedStats();
        MinMaxAvgStats alignmentDurationStats = taskStatisticsSummary.getAlignmentDurationStats();
        TaskCheckpointStatisticsWithSubtaskDetails.CheckpointAlignment checkpointAlignment = new TaskCheckpointStatisticsWithSubtaskDetails.CheckpointAlignment(new MinMaxAvgStatistics(alignmentBufferedStats.getMinimum(), alignmentBufferedStats.getMaximum(), alignmentBufferedStats.getAverage()), new MinMaxAvgStatistics(alignmentDurationStats.getMinimum(), alignmentDurationStats.getMaximum(), alignmentDurationStats.getAverage()));
        return new TaskCheckpointStatisticsWithSubtaskDetails.Summary(new MinMaxAvgStatistics(stateSizeStats.getMinimum(), stateSizeStats.getMaximum(), stateSizeStats.getAverage()), new MinMaxAvgStatistics(Math.max(0L, ackTSStats.getMinimum() - triggerTimestamp), Math.max(0L, ackTSStats.getMaximum() - triggerTimestamp), Math.max(0L, ackTSStats.getAverage() - triggerTimestamp)), checkpointDuration, checkpointAlignment);
    }

    private static List<SubtaskCheckpointStatistics> createSubtaskCheckpointStatistics(SubtaskStateStats[] subtaskStateStats, long triggerTimestamp) {
        ArrayList<SubtaskCheckpointStatistics> result = new ArrayList<SubtaskCheckpointStatistics>(subtaskStateStats.length);
        for (int i = 0; i < subtaskStateStats.length; ++i) {
            SubtaskStateStats subtask = subtaskStateStats[i];
            if (subtask == null) {
                result.add(new SubtaskCheckpointStatistics.PendingSubtaskCheckpointStatistics(i));
                continue;
            }
            result.add(new SubtaskCheckpointStatistics.CompletedSubtaskCheckpointStatistics(i, subtask.getAckTimestamp(), subtask.getEndToEndDuration(triggerTimestamp), subtask.getStateSize(), new SubtaskCheckpointStatistics.CompletedSubtaskCheckpointStatistics.CheckpointDuration(subtask.getSyncCheckpointDuration(), subtask.getAsyncCheckpointDuration()), new SubtaskCheckpointStatistics.CompletedSubtaskCheckpointStatistics.CheckpointAlignment(subtask.getAlignmentBuffered(), subtask.getAlignmentDuration())));
        }
        return result;
    }
}

