/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.ComponentMetric;
import org.apache.flink.runtime.rest.messages.job.metrics.ComponentsFilterParameter;
import org.apache.flink.runtime.rest.messages.job.metrics.ComponentsMetricCollectionResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricsFilterParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public abstract class AbstractComponentsMetricsHandler<M extends MessageParameters>
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, ComponentsMetricCollectionResponseBody, M> {
    private final MetricFetcher metricFetcher;

    public AbstractComponentsMetricsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> headers, MessageHeaders<EmptyRequestBody, ComponentsMetricCollectionResponseBody, M> messageHeaders, MetricFetcher metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, headers, messageHeaders);
        this.metricFetcher = Objects.requireNonNull(metricFetcher, "metricFetcher must not be null");
    }

    @Override
    protected final CompletableFuture<ComponentsMetricCollectionResponseBody> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, M> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        this.metricFetcher.update();
        Set<String> requestedComponenets = this.getAvailableComponents(new HashSet<String>(request.getQueryParameter(ComponentsFilterParameter.class)), gateway, request);
        if (requestedComponenets == null || requestedComponenets.isEmpty()) {
            return CompletableFuture.completedFuture(new ComponentsMetricCollectionResponseBody(Collections.emptyList()));
        }
        MetricStore metricStore = this.metricFetcher.getMetricStore();
        Map<String, MetricStore.ComponentMetricStore> componentId2MetricStores = this.getComponentId2MetricStores(request, metricStore, requestedComponenets);
        if (componentId2MetricStores == null || componentId2MetricStores.isEmpty()) {
            return CompletableFuture.completedFuture(new ComponentsMetricCollectionResponseBody(Collections.emptyList()));
        }
        HashSet<String> requestedMetrics = new HashSet<String>(request.getQueryParameter(MetricsFilterParameter.class));
        ArrayList<ComponentMetric> componentMetricList = new ArrayList<ComponentMetric>();
        for (Map.Entry<String, MetricStore.ComponentMetricStore> componentId2MetricStore : componentId2MetricStores.entrySet()) {
            MetricStore.ComponentMetricStore componentMetricStore = componentId2MetricStore.getValue();
            String componentId = componentId2MetricStore.getKey();
            if (componentMetricStore == null || componentMetricStore.metrics == null) continue;
            List<Metric> metrics = requestedMetrics.isEmpty() ? AbstractComponentsMetricsHandler.getAvailableMetrics(componentMetricStore) : AbstractComponentsMetricsHandler.getRequestedMetrics(componentMetricStore, requestedMetrics);
            ComponentMetric componentMetric = new ComponentMetric(componentId, metricStore.getTimestamp(), metrics);
            componentMetricList.add(componentMetric);
        }
        return CompletableFuture.completedFuture(new ComponentsMetricCollectionResponseBody(componentMetricList));
    }

    protected abstract Map<String, MetricStore.ComponentMetricStore> getComponentId2MetricStores(HandlerRequest<EmptyRequestBody, M> var1, MetricStore var2, Set<String> var3);

    protected Set<String> getAvailableComponents(Set<String> requestedComponenets, RestfulGateway gateway, HandlerRequest<EmptyRequestBody, M> request) throws NotFoundException {
        return requestedComponenets;
    }

    private static List<Metric> getAvailableMetrics(MetricStore.ComponentMetricStore componentMetricStore) {
        return componentMetricStore.metrics.keySet().stream().map(Metric::new).collect(Collectors.toList());
    }

    private static List<Metric> getRequestedMetrics(MetricStore.ComponentMetricStore componentMetricStore, Set<String> requestedMetrics) throws RestHandlerException {
        ArrayList<Metric> metrics = new ArrayList<Metric>(requestedMetrics.size());
        for (String requestedMetric : requestedMetrics) {
            String value = componentMetricStore.getMetric(requestedMetric, null);
            if (value == null) continue;
            metrics.add(new Metric(requestedMetric, value));
        }
        return metrics;
    }
}

