/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractJobComponentMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexSubtasksComponentMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexSubtasksComponentMetricsMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobVertexSubtasksComponentMetricsHandler
extends AbstractJobComponentMetricsHandler<JobVertexSubtasksComponentMetricsMessageParameters> {
    public JobVertexSubtasksComponentMetricsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> headers, ExecutionGraphCache executionGraphCache, MetricFetcher metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, headers, JobVertexSubtasksComponentMetricsHeaders.getInstance(), executionGraphCache, metricFetcher);
    }

    @Override
    @Nullable
    protected Map<String, MetricStore.ComponentMetricStore> getComponentId2MetricStores(HandlerRequest<EmptyRequestBody, JobVertexSubtasksComponentMetricsMessageParameters> request, MetricStore metricStore, Set<String> requestedComponents) {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID vertexId = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        HashMap<String, MetricStore.ComponentMetricStore> componentId2MetricStores = new HashMap<String, MetricStore.ComponentMetricStore>();
        if (requestedComponents.isEmpty()) {
            return componentId2MetricStores;
        }
        for (String componentId : requestedComponents) {
            int subtaskIndex = Integer.valueOf(componentId);
            MetricStore.ComponentMetricStore componentMetricStore = metricStore.getSubtaskMetricStore(jobId.toString(), vertexId.toString(), subtaskIndex);
            componentId2MetricStores.put(componentId, componentMetricStore);
        }
        return componentId2MetricStores;
    }

    @Override
    protected Set<String> getAvailableComponents(AccessExecutionGraph executionGraph, HandlerRequest<EmptyRequestBody, JobVertexSubtasksComponentMetricsMessageParameters> request) throws NotFoundException {
        JobVertexID vertexId = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        AccessExecutionJobVertex jobVertex = executionGraph.getJobVertex(vertexId);
        if (jobVertex == null) {
            throw new NotFoundException(String.format("JobVertex %s not found", new Object[]{vertexId}));
        }
        HashSet<String> subtaskIndexStr = new HashSet<String>();
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            subtaskIndexStr.add("" + vertex.getParallelSubtaskIndex());
        }
        return subtaskIndexStr;
    }
}

