/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.util.KeepAliveWrite;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;

@ChannelHandler.Sharable
public class ConstantTextHandler
extends SimpleChannelInboundHandler<RoutedRequest> {
    private final byte[] encodedText;

    public ConstantTextHandler(String text) {
        this.encodedText = text.getBytes(ConfigConstants.DEFAULT_CHARSET);
    }

    protected void channelRead0(ChannelHandlerContext ctx, RoutedRequest routed) throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.encodedText));
        response.headers().set("Content-Length", (Object)this.encodedText.length);
        response.headers().set("Content-Type", (Object)"text/plain");
        KeepAliveWrite.flush(ctx, routed.getRequest(), (HttpResponse)response);
    }
}

