/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJobVertexRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class JobVertexTaskManagersHandler
extends AbstractJobVertexRequestHandler {
    private static final String JOB_VERTEX_TASKMANAGERS_REST_PATH = "/jobs/:jobid/vertices/:vertexid/taskmanagers";
    private final MetricFetcher fetcher;

    public JobVertexTaskManagersHandler(ExecutionGraphCache executionGraphHolder, Executor executor, MetricFetcher fetcher) {
        super(executionGraphHolder, executor);
        this.fetcher = fetcher;
    }

    @Override
    public String[] getPaths() {
        return new String[]{JOB_VERTEX_TASKMANAGERS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionJobVertex jobVertex, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return JobVertexTaskManagersHandler.createVertexDetailsByTaskManagerJson(jobVertex, (String)params.get("jobid"), this.fetcher);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not create TaskManager json.", (Throwable)e));
            }
        }, this.executor);
    }

    public static String createVertexDetailsByTaskManagerJson(AccessExecutionJobVertex jobVertex, String jobID, @Nullable MetricFetcher fetcher) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        HashMap<String, ArrayList<AccessExecutionVertex>> taskManagerVertices = new HashMap<String, ArrayList<AccessExecutionVertex>>();
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            TaskManagerLocation location = vertex.getCurrentAssignedResourceLocation();
            String taskManager = location == null ? "(unassigned)" : location.getHostname() + ":" + location.dataPort();
            ArrayList<AccessExecutionVertex> vertices = (ArrayList<AccessExecutionVertex>)taskManagerVertices.get(taskManager);
            if (vertices == null) {
                vertices = new ArrayList<AccessExecutionVertex>();
                taskManagerVertices.put(taskManager, vertices);
            }
            vertices.add(vertex);
        }
        long now = System.currentTimeMillis();
        gen.writeStartObject();
        gen.writeStringField("id", jobVertex.getJobVertexId().toString());
        gen.writeStringField("name", jobVertex.getName());
        gen.writeNumberField("now", now);
        gen.writeArrayFieldStart("taskmanagers");
        for (Map.Entry entry : taskManagerVertices.entrySet()) {
            long duration;
            String host = (String)entry.getKey();
            List taskVertices = (List)entry.getValue();
            int[] tasksPerState = new int[ExecutionState.values().length];
            long startTime = Long.MAX_VALUE;
            long endTime = 0L;
            boolean allFinished = true;
            MutableIOMetrics counts = new MutableIOMetrics();
            for (AccessExecutionVertex vertex : taskVertices) {
                ExecutionState state = vertex.getExecutionState();
                int n = state.ordinal();
                tasksPerState[n] = tasksPerState[n] + 1;
                long started = vertex.getStateTimestamp(ExecutionState.DEPLOYING);
                if (started > 0L) {
                    startTime = Math.min(startTime, started);
                }
                allFinished &= state.isTerminal();
                endTime = Math.max(endTime, vertex.getStateTimestamp(state));
                counts.addIOMetrics(vertex.getCurrentExecutionAttempt(), fetcher, jobID, jobVertex.getJobVertexId().toString());
            }
            if (startTime < Long.MAX_VALUE) {
                if (allFinished) {
                    duration = endTime - startTime;
                } else {
                    endTime = -1L;
                    duration = now - startTime;
                }
            } else {
                startTime = -1L;
                endTime = -1L;
                duration = -1L;
            }
            ExecutionState jobVertexState = ExecutionJobVertex.getAggregateJobVertexState(tasksPerState, taskVertices.size());
            gen.writeStartObject();
            gen.writeStringField("host", host);
            gen.writeStringField("status", jobVertexState.name());
            gen.writeNumberField("start-time", startTime);
            gen.writeNumberField("end-time", endTime);
            gen.writeNumberField("duration", duration);
            counts.writeIOMetricsAsJson(gen);
            gen.writeObjectFieldStart("status-counts");
            for (ExecutionState state : ExecutionState.values()) {
                gen.writeNumberField(state.name(), tasksPerState[state.ordinal()]);
            }
            gen.writeEndObject();
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class JobVertexTaskManagersJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>();
            for (AccessExecutionJobVertex accessExecutionJobVertex : graph.getAllVertices().values()) {
                String json = JobVertexTaskManagersHandler.createVertexDetailsByTaskManagerJson(accessExecutionJobVertex, graph.getJobID().toString(), null);
                String path = JobVertexTaskManagersHandler.JOB_VERTEX_TASKMANAGERS_REST_PATH.replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString());
                archive.add(new ArchivedJson(path, json));
            }
            return archive;
        }
    }
}

