/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJobVertexRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class SubtasksAllAccumulatorsHandler
extends AbstractJobVertexRequestHandler {
    private static final String SUBTASKS_ALL_ACCUMULATORS_REST_PATH = "/jobs/:jobid/vertices/:vertexid/subtasks/accumulators";

    public SubtasksAllAccumulatorsHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public String[] getPaths() {
        return new String[]{SUBTASKS_ALL_ACCUMULATORS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionJobVertex jobVertex, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return SubtasksAllAccumulatorsHandler.createSubtasksAccumulatorsJson(jobVertex);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not create subtasks accumulator json.", (Throwable)e));
            }
        }, this.executor);
    }

    public static String createSubtasksAccumulatorsJson(AccessExecutionJobVertex jobVertex) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeStringField("id", jobVertex.getJobVertexId().toString());
        gen.writeNumberField("parallelism", jobVertex.getParallelism());
        gen.writeArrayFieldStart("subtasks");
        int num = 0;
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            TaskManagerLocation location = vertex.getCurrentAssignedResourceLocation();
            String locationString = location == null ? "(unassigned)" : location.getHostname();
            gen.writeStartObject();
            gen.writeNumberField("subtask", num++);
            gen.writeNumberField("attempt", vertex.getCurrentExecutionAttempt().getAttemptNumber());
            gen.writeStringField("host", locationString);
            StringifiedAccumulatorResult[] accs = vertex.getCurrentExecutionAttempt().getUserAccumulatorsStringified();
            gen.writeArrayFieldStart("user-accumulators");
            for (StringifiedAccumulatorResult acc : accs) {
                gen.writeStartObject();
                gen.writeStringField("name", acc.getName());
                gen.writeStringField("type", acc.getType());
                gen.writeStringField("value", acc.getValue());
                gen.writeEndObject();
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class SubtasksAllAccumulatorsJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>();
            for (AccessExecutionJobVertex accessExecutionJobVertex : graph.getAllVertices().values()) {
                String json = SubtasksAllAccumulatorsHandler.createSubtasksAccumulatorsJson(accessExecutionJobVertex);
                String path = SubtasksAllAccumulatorsHandler.SUBTASKS_ALL_ACCUMULATORS_REST_PATH.replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString());
                archive.add(new ArchivedJson(path, json));
            }
            return archive;
        }
    }
}

