/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.ExecutionVertexIDInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.util.Preconditions;

public class TaskManagerExecutionVertexCache
implements Closeable {
    private final Time timeout;
    private final Time timeToLive;
    private final Map<ResourceID, List<ExecutionVertexIDInfo>> cachedExcutionVertixIds;
    private volatile boolean running = true;
    private long ttl;

    public TaskManagerExecutionVertexCache(Time timeout, Time timeToLive) {
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.timeToLive = (Time)Preconditions.checkNotNull((Object)timeToLive);
        this.ttl = System.currentTimeMillis() + timeToLive.toMilliseconds();
        this.cachedExcutionVertixIds = new ConcurrentHashMap<ResourceID, List<ExecutionVertexIDInfo>>(100);
    }

    @Override
    public void close() {
        this.running = false;
        this.cachedExcutionVertixIds.clear();
    }

    public int size() {
        return this.cachedExcutionVertixIds.size();
    }

    public List<ExecutionVertexIDInfo> getTaskManagerExecutionVertex(ResourceID taskmanagerId, RestfulGateway restfulGateway, ExecutionGraphCache executionGraphCache) throws Exception {
        Preconditions.checkState((boolean)this.running, (Object)"TaskManagerExecutionVertexCache is no longer running");
        List<ExecutionVertexIDInfo> executionVertexIds = this.cachedExcutionVertixIds.get(taskmanagerId);
        long currentTime = System.currentTimeMillis();
        if (executionVertexIds != null && currentTime < this.ttl) {
            return executionVertexIds;
        }
        MultipleJobsDetails jobs = restfulGateway.requestMultipleJobDetails(this.timeout).get();
        HashMap tmId2ExcutionVertixIds = new HashMap();
        if (jobs != null && jobs.getJobs().size() > 0) {
            List jobIds = jobs.getJobs().stream().filter(job -> job.getStatus() == JobStatus.RUNNING).map(JobDetails::getJobId).collect(Collectors.toList());
            for (JobID jobid : jobIds) {
                AccessExecutionGraph executionGraph = executionGraphCache.getExecutionGraph(jobid, restfulGateway).get();
                for (AccessExecutionJobVertex accessExecutionJobVertex : executionGraph.getVerticesTopologically()) {
                    JobVertexID jobVertexID = accessExecutionJobVertex.getJobVertexId();
                    for (AccessExecutionVertex executionVertex : accessExecutionJobVertex.getTaskVertices()) {
                        AccessExecution execution = executionVertex.getCurrentExecutionAttempt();
                        if (null == execution.getAssignedResourceLocation()) continue;
                        ResourceID currentTaskTaskmanagerId = execution.getAssignedResourceLocation().getResourceID();
                        ArrayList<ExecutionVertexIDInfo> tmExecutionVertexIds = (ArrayList<ExecutionVertexIDInfo>)tmId2ExcutionVertixIds.get(currentTaskTaskmanagerId);
                        if (tmExecutionVertexIds == null) {
                            tmExecutionVertexIds = new ArrayList<ExecutionVertexIDInfo>();
                        }
                        ExecutionVertexIDInfo executionVertexId = new ExecutionVertexIDInfo(jobVertexID, execution.getParallelSubtaskIndex());
                        tmExecutionVertexIds.add(executionVertexId);
                        tmId2ExcutionVertixIds.put(currentTaskTaskmanagerId, tmExecutionVertexIds);
                    }
                }
            }
        }
        this.cachedExcutionVertixIds.putAll(tmId2ExcutionVertixIds);
        this.ttl = currentTime + this.timeToLive.toMilliseconds();
        return this.cachedExcutionVertixIds.get(taskmanagerId);
    }
}

