/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.RedirectHandler;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.util.MimeTypes;
import org.apache.flink.runtime.util.FileOffsetRange;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.channel.DefaultFileRegion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedFile;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.util.CharsetUtil;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.apache.flink.util.Preconditions;

@ChannelHandler.Sharable
public class StaticFileServerHandler<T extends RestfulGateway>
extends RedirectHandler<T> {
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final int HTTP_CACHE_SECONDS = 300;
    private final File rootPath;

    public StaticFileServerHandler(GatewayRetriever<? extends T> retriever, CompletableFuture<String> localJobManagerAddressFuture, Time timeout, File rootPath) throws IOException {
        super(localJobManagerAddressFuture, retriever, timeout, Collections.emptyMap());
        this.rootPath = ((File)Preconditions.checkNotNull((Object)rootPath)).getCanonicalFile();
    }

    @Override
    protected void respondAsLeader(ChannelHandlerContext channelHandlerContext, RoutedRequest routedRequest, T gateway) throws Exception {
        HttpRequest request = routedRequest.getRequest();
        String fileReadStartFromQueryParameter = routedRequest.getRouteResult().queryParam("start");
        String countFromQueryParameter = routedRequest.getRouteResult().queryParam("count");
        Long start2 = StringUtils.isNotBlank((CharSequence)fileReadStartFromQueryParameter) ? Long.valueOf(Long.parseLong(fileReadStartFromQueryParameter)) : null;
        Long count = StringUtils.isNotBlank((CharSequence)countFromQueryParameter) ? Long.valueOf(Long.parseLong(countFromQueryParameter)) : null;
        String requestPath = routedRequest.getPath().endsWith("/") ? routedRequest.getPath() + "index.html" : (routedRequest.getPath().equals("/jobmanager/log") || routedRequest.getPath().equals("/jobmanager/stdout") ? "" : routedRequest.getPath());
        this.respondToRequest(channelHandlerContext, request, requestPath, start2, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void respondToRequest(ChannelHandlerContext ctx, HttpRequest request, String requestPath, Long start, Long count) throws IOException, ParseException, URISyntaxException {
        block42: {
            file = new File(this.rootPath, requestPath);
            if (file.exists()) break block42;
            cl = StaticFileServerHandler.class.getClassLoader();
            resourceStream = cl.getResourceAsStream("web" + requestPath);
            var9_9 = null;
            try {
                success = false;
                try {
                    if (resourceStream != null) {
                        root = cl.getResource("web");
                        requested = cl.getResource("web" + requestPath);
                        if (root != null && requested != null && !(rootURI = new URI(root.getPath()).normalize()).relativize(requestedURI = new URI(requested.getPath()).normalize()).equals(requestedURI)) {
                            this.logger.debug("Loading missing file from classloader: {}", (Object)requestPath);
                            file.getParentFile().mkdirs();
                            Files.copy(resourceStream, file.toPath(), new CopyOption[0]);
                            success = true;
                        }
                    }
                    ** if (success) goto lbl-1000
                }
                catch (Throwable t) {
                    block43: {
                        block44: {
                            this.logger.error("error while responding", t);
                            if (success) break block42;
                            this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                            StaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                            if (resourceStream == null) break block43;
                            if (var9_9 == null) break block44;
                            try {
                                resourceStream.close();
                            }
                            catch (Throwable t) {
                                var9_9.addSuppressed(t);
                            }
                            break block43;
                        }
                        resourceStream.close();
                    }
                    return;
                    {
                        catch (Throwable var15_22) {
                            block45: {
                                block46: {
                                    block47: {
                                        if (success) break block45;
                                        this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                                        StaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                                        if (resourceStream == null) break block46;
                                        if (var9_9 == null) break block47;
                                        try {
                                            resourceStream.close();
                                        }
                                        catch (Throwable var16_24) {
                                            var9_9.addSuppressed(var16_24);
                                        }
                                        break block46;
                                    }
                                    resourceStream.close();
                                }
                                return;
                            }
                            try {
                                throw var15_22;
                            }
                            catch (Throwable var10_14) {
                                var9_9 = var10_14;
                                throw var10_14;
                            }
                            catch (Throwable var17_25) {
                                throw var17_25;
                            }
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                    this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                    StaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
lbl-1000:
                // 1 sources

                {
                }
            }
            finally {
                if (resourceStream != null) {
                    if (var9_9 != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable root) {
                            var9_9.addSuppressed(root);
                        }
                    } else {
                        resourceStream.close();
                    }
                }
            }
        }
        if (!file.exists() || file.isHidden() || file.isDirectory() || !file.isFile()) {
            StaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        if (!file.getCanonicalFile().toPath().startsWith(this.rootPath.toPath())) {
            StaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        ifModifiedSince = request.headers().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Responding 'NOT MODIFIED' for file '" + file.getAbsolutePath() + '\'');
            }
            StaticFileServerHandler.sendNotModified(ctx);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Responding with file '" + file.getAbsolutePath() + '\'');
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            StaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        try {
            fileLength = raf.length();
            start = start != null ? start : FileOffsetRange.getStartDefaultValue();
            count = count != null ? count : FileOffsetRange.getSizeDefaultValue();
            fs = new FileOffsetRange(start, count).normalize(fileLength);
            position = fs.getStart();
            fileLength = fs.getSize();
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            StaticFileServerHandler.setContentTypeHeader((HttpResponse)response, file);
            if (!requestPath.contains("log") && !requestPath.contains("out")) {
                StaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, file);
            }
            if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
                response.headers().set("Connection", (Object)"keep-alive");
            }
            HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
            ctx.write((Object)response);
            if (ctx.pipeline().get(SslHandler.class) == null) {
                ctx.write((Object)new DefaultFileRegion(raf.getChannel(), position, fileLength), (ChannelPromise)ctx.newProgressivePromise());
                lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                lastContentFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, position, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
            }
            if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            raf.close();
            this.logger.error("Failed to serve file.", (Throwable)e);
            StaticFileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx.channel().isActive()) {
            this.logger.error("Caught exception", cause);
            StaticFileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        StaticFileServerHandler.setDateHeader((FullHttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static void setDateHeader(FullHttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
    }

    public static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 300);
        response.headers().set("Expires", (Object)dateFormatter.format(time.getTime()));
        response.headers().set("Cache-Control", (Object)"private, max-age=300");
        response.headers().set("Last-Modified", (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    public static void setContentTypeHeader(HttpResponse response, File file) {
        String mimeType = MimeTypes.getMimeTypeForFileName(file.getName());
        String mimeFinal = mimeType != null ? mimeType : MimeTypes.getDefaultMimeType();
        response.headers().set("Content-Type", (Object)mimeFinal);
    }
}

