/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.taskmanager.AbstractTaskManagerHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagersInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobTaskManagersHandler
extends AbstractTaskManagerHandler<RestfulGateway, EmptyRequestBody, TaskManagersInfo, JobMessageParameters> {
    private final ExecutionGraphCache executionGraphCache;
    private final GatewayRetriever<? extends RestfulGateway> leaderRetriever;

    public JobTaskManagersHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, TaskManagersInfo, JobMessageParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, ExecutionGraphCache executionGraphCache) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, resourceManagerGatewayRetriever);
        this.executionGraphCache = executionGraphCache;
        this.leaderRetriever = leaderRetriever;
    }

    @Override
    protected CompletableFuture<TaskManagersInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, JobMessageParameters> request, @Nonnull ResourceManagerGateway gateway) throws RestHandlerException {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        CompletableFuture<Collection<TaskManagerInfo>> taskManagerInfosFuture = gateway.requestTaskManagerInfo(this.timeout);
        RestfulGateway restfulGateway = this.leaderRetriever.getNow().get();
        return taskManagerInfosFuture.thenApply(taskManagerInfos -> JobTaskManagersHandler.getJobTaskManagerInfo(taskManagerInfos, jobId, this.executionGraphCache, restfulGateway));
    }

    private static TaskManagersInfo getJobTaskManagerInfo(Collection<TaskManagerInfo> taskManagerInfos, JobID jobId, ExecutionGraphCache executionGraphCache, RestfulGateway restfulGateway) {
        AccessExecutionGraph executionGraph = null;
        HashSet<TaskManagerInfo> jobTaskManagerInfos = new HashSet<TaskManagerInfo>();
        HashMap<String, TaskManagerInfo> resourceId2taskManagerInfo = new HashMap<String, TaskManagerInfo>();
        try {
            executionGraph = executionGraphCache.getExecutionGraph(jobId, restfulGateway).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (executionGraph != null) {
            for (TaskManagerInfo taskManagerInfo : taskManagerInfos) {
                resourceId2taskManagerInfo.put(taskManagerInfo.getResourceId().toString(), taskManagerInfo);
            }
            for (AccessExecutionJobVertex accessExecutionJobVertex : executionGraph.getVerticesTopologically()) {
                for (AccessExecutionVertex task : accessExecutionJobVertex.getTaskVertices()) {
                    ResourceID tmId;
                    TaskManagerInfo taskManagerInfo;
                    TaskManagerLocation taskManagerLocation = task.getCurrentAssignedResourceLocation();
                    if (taskManagerLocation == null || (taskManagerInfo = (TaskManagerInfo)resourceId2taskManagerInfo.get((tmId = taskManagerLocation.getResourceID()).toString())) == null) continue;
                    jobTaskManagerInfos.add(taskManagerInfo);
                }
            }
        }
        TaskManagersInfo tms = new TaskManagersInfo(jobTaskManagerInfos);
        return tms;
    }
}

