/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;

public class MutableIOMetrics
extends IOMetrics {
    private static final long serialVersionUID = -5460777634971381737L;
    private boolean numBytesInLocalComplete = true;
    private boolean numBytesInRemoteComplete = true;
    private boolean numBytesOutComplete = true;
    private boolean numRecordsInComplete = true;
    private boolean numRecordsOutComplete = true;
    private float bufferInPoolUsageMax = 0.0f;
    private float bufferOutPoolUsageMax = 0.0f;
    private boolean bufferInPoolUsageMaxComplete = true;
    private boolean bufferOutPoolUsageMaxComplete = true;
    private double tps = -1.0;
    private boolean tpsComplete = true;
    private long delay = -1L;
    private boolean delayComplete = true;

    public MutableIOMetrics() {
        super(0L, 0L, 0L, 0L, 0L, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public boolean isNumBytesInLocalComplete() {
        return this.numBytesInLocalComplete;
    }

    public boolean isNumBytesInRemoteComplete() {
        return this.numBytesInRemoteComplete;
    }

    public boolean isNumBytesOutComplete() {
        return this.numBytesOutComplete;
    }

    public boolean isNumRecordsInComplete() {
        return this.numRecordsInComplete;
    }

    public boolean isNumRecordsOutComplete() {
        return this.numRecordsOutComplete;
    }

    public boolean isBufferInPoolUsageMaxComplete() {
        return this.bufferInPoolUsageMaxComplete;
    }

    public boolean isBufferOutPoolUsageMaxComplete() {
        return this.bufferOutPoolUsageMaxComplete;
    }

    public float getBufferInPoolUsageMax() {
        return this.bufferInPoolUsageMax;
    }

    public float getBufferOutPoolUsageMax() {
        return this.bufferOutPoolUsageMax;
    }

    public double getTps() {
        return this.tps;
    }

    public boolean isTpsComplete() {
        return this.tpsComplete;
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean isDelayComplete() {
        return this.delayComplete;
    }

    public void addIOMetrics(AccessExecution attempt, @Nullable MetricFetcher fetcher, String jobID, String taskID) {
        if (attempt.getState().isTerminal()) {
            IOMetrics ioMetrics = attempt.getIOMetrics();
            if (ioMetrics != null) {
                this.numBytesInLocal += ioMetrics.getNumBytesInLocal();
                this.numBytesInRemote += ioMetrics.getNumBytesInRemote();
                this.numBytesOut += ioMetrics.getNumBytesOut();
                this.numRecordsIn += ioMetrics.getNumRecordsIn();
                this.numRecordsOut += ioMetrics.getNumRecordsOut();
            }
        } else if (fetcher != null) {
            fetcher.update();
            MetricStore.ComponentMetricStore metrics = fetcher.getMetricStore().getSubtaskMetricStore(jobID, taskID, attempt.getParallelSubtaskIndex());
            if (metrics != null) {
                boolean findTps = false;
                double tps = 0.0;
                for (Map.Entry<String, String> entry : metrics.getMetrics().entrySet()) {
                    if (entry.getKey().endsWith(".tps") && StringUtils.isNotBlank((CharSequence)entry.getValue())) {
                        tps = Double.valueOf(entry.getValue());
                        findTps = true;
                        continue;
                    }
                    if (!entry.getKey().endsWith(".delay") || !StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
                    long delay = Long.valueOf(entry.getValue());
                    this.delay = Math.max(delay, this.delay);
                }
                if (metrics.getMetric("numBytesInLocal") == null) {
                    this.numBytesInLocalComplete = false;
                } else {
                    this.numBytesInLocal += Long.valueOf(metrics.getMetric("numBytesInLocal")).longValue();
                }
                if (metrics.getMetric("numBytesInRemote") == null) {
                    this.numBytesInRemoteComplete = false;
                } else {
                    this.numBytesInRemote += Long.valueOf(metrics.getMetric("numBytesInRemote")).longValue();
                }
                if (metrics.getMetric("numBytesOut") == null) {
                    this.numBytesOutComplete = false;
                } else {
                    this.numBytesOut += Long.valueOf(metrics.getMetric("numBytesOut")).longValue();
                }
                if (metrics.getMetric("numRecordsIn") == null) {
                    this.numRecordsInComplete = false;
                } else {
                    this.numRecordsIn += Long.valueOf(metrics.getMetric("numRecordsIn")).longValue();
                }
                if (metrics.getMetric("numRecordsOut") == null) {
                    this.numRecordsOutComplete = false;
                } else {
                    this.numRecordsOut += Long.valueOf(metrics.getMetric("numRecordsOut")).longValue();
                }
                if (metrics.getMetric("buffers.inPoolUsage") == null) {
                    this.bufferInPoolUsageMaxComplete = false;
                } else {
                    float bufferInQueue = Float.valueOf(metrics.getMetric("buffers.inPoolUsage")).floatValue();
                    this.bufferInPoolUsageMax = Math.max(bufferInQueue, this.bufferInPoolUsageMax);
                }
                if (metrics.getMetric("buffers.outPoolUsage") == null) {
                    this.bufferOutPoolUsageMaxComplete = false;
                } else {
                    float bufferOutQueue = Float.valueOf(metrics.getMetric("buffers.outPoolUsage")).floatValue();
                    this.bufferOutPoolUsageMax = Math.max(bufferOutQueue, this.bufferOutPoolUsageMax);
                }
                if (!findTps && metrics.getMetric("numRecordsInPerSecond") != null) {
                    tps = Double.valueOf(metrics.getMetric("numRecordsInPerSecond"));
                    findTps = true;
                }
                if (findTps) {
                    this.tps = this.tps == -1.0 ? tps : (this.tps += tps);
                }
            } else {
                this.numBytesInLocalComplete = false;
                this.numBytesInRemoteComplete = false;
                this.numBytesOutComplete = false;
                this.numRecordsInComplete = false;
                this.numRecordsOutComplete = false;
                this.bufferInPoolUsageMaxComplete = false;
                this.bufferOutPoolUsageMaxComplete = false;
                this.tpsComplete = false;
                this.delayComplete = false;
            }
        }
    }

    public void writeIOMetricsAsJson(JsonGenerator gen) throws IOException {
        gen.writeObjectFieldStart("metrics");
        Long numBytesIn = this.numBytesInLocal + this.numBytesInRemote;
        gen.writeNumberField("read-bytes", numBytesIn.longValue());
        gen.writeBooleanField("read-bytes-complete", this.numBytesInLocalComplete && this.numBytesInRemoteComplete);
        gen.writeNumberField("write-bytes", this.numBytesOut);
        gen.writeBooleanField("write-bytes-complete", this.numBytesOutComplete);
        gen.writeNumberField("read-records", this.numRecordsIn);
        gen.writeBooleanField("read-records-complete", this.numRecordsInComplete);
        gen.writeNumberField("write-records", this.numRecordsOut);
        gen.writeBooleanField("write-records-complete", this.numRecordsOutComplete);
        gen.writeNumberField("buffers-in-pool-usage-max", this.bufferInPoolUsageMax);
        gen.writeBooleanField("buffers-in-pool-usage_max-complete", this.bufferInPoolUsageMaxComplete);
        gen.writeNumberField("buffers-out-pool-usage-max", this.bufferOutPoolUsageMax);
        gen.writeBooleanField("buffers-out-pool-usage-max-complete", this.bufferOutPoolUsageMaxComplete);
        gen.writeEndObject();
    }
}

