/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class JobVertexDetailsInfo
implements ResponseBody {
    public static final String FIELD_NAME_VERTEX_ID = "id";
    public static final String FIELD_NAME_VERTEX_NAME = "name";
    public static final String FIELD_NAME_PARALLELISM = "parallelism";
    public static final String FIELD_NAME_NOW = "now";
    public static final String FIELD_NAME_SUBTASKS = "subtasks";
    @JsonProperty(value="id")
    @JsonSerialize(using=JobVertexIDSerializer.class)
    private final JobVertexID id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="parallelism")
    private final int parallelism;
    @JsonProperty(value="now")
    private final long now;
    @JsonProperty(value="subtasks")
    private final List<VertexTaskDetail> subtasks;

    @JsonCreator
    public JobVertexDetailsInfo(@JsonDeserialize(using=JobVertexIDDeserializer.class) @JsonProperty(value="id") JobVertexID id, @JsonProperty(value="name") String name, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="now") long now, @JsonProperty(value="subtasks") List<VertexTaskDetail> subtasks) {
        this.id = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)id)));
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.parallelism = parallelism;
        this.now = now;
        this.subtasks = (List)Preconditions.checkNotNull(subtasks);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        JobVertexDetailsInfo that = (JobVertexDetailsInfo)o;
        return Objects.equals((Object)this.id, (Object)that.id) && Objects.equals(this.name, that.name) && this.parallelism == that.parallelism && this.now == that.now && Objects.equals(this.subtasks, that.subtasks);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.parallelism, this.now, this.subtasks});
    }

    public static final class VertexTaskDetail {
        public static final String FIELD_NAME_SUBTASK = "subtask";
        public static final String FIELD_NAME_STATUS = "status";
        public static final String FIELD_NAME_ATTEMPT = "attempt";
        public static final String FIELD_NAME_HOST = "host";
        public static final String FIELD_NAME_START_TIME = "start-time";
        public static final String FIELD_NAME_END_TIME = "end-time";
        public static final String FIELD_NAME_DURATION = "duration";
        public static final String FIELD_NAME_METRICS = "metrics";
        public static final String FIELD_NAME_RESOURCE_ID = "resource-id";
        public static final String FIELD_NAME_LOG_FILE_NAME = "log-file-name";
        public static final String FIELD_NAME_STDOUT_FILE_NAME = "stdout-file-name";
        @JsonProperty(value="subtask")
        private final int subtask;
        @JsonProperty(value="status")
        private final ExecutionState status;
        @JsonProperty(value="attempt")
        private final int attempt;
        @JsonProperty(value="host")
        private final String host;
        @JsonProperty(value="start-time")
        private final long startTime;
        @JsonProperty(value="end-time")
        private final long endTime;
        @JsonProperty(value="duration")
        private final long duration;
        @JsonProperty(value="metrics")
        private final IOMetricsInfo metrics;
        @JsonProperty(value="resource-id")
        private final String resourceId;
        @JsonProperty(value="log-file-name")
        private final String logFileName;
        @JsonProperty(value="stdout-file-name")
        private final String stdoutFileName;

        @JsonCreator
        public VertexTaskDetail(@JsonProperty(value="subtask") int subtask, @JsonProperty(value="status") ExecutionState status, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="host") String host, @JsonProperty(value="start-time") long startTime, @JsonProperty(value="end-time") long endTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="metrics") IOMetricsInfo metrics, @JsonProperty(value="resource-id") String resourceId, @JsonProperty(value="log-file-name") String logFileName, @JsonProperty(value="stdout-file-name") String stdoutFileName) {
            this.subtask = subtask;
            this.status = (ExecutionState)((Object)Preconditions.checkNotNull((Object)((Object)status)));
            this.attempt = attempt;
            this.host = (String)Preconditions.checkNotNull((Object)host);
            this.startTime = startTime;
            this.endTime = endTime;
            this.duration = duration;
            this.metrics = (IOMetricsInfo)Preconditions.checkNotNull((Object)metrics);
            this.resourceId = (String)Preconditions.checkNotNull((Object)resourceId);
            this.logFileName = (String)Preconditions.checkNotNull((Object)logFileName);
            this.stdoutFileName = (String)Preconditions.checkNotNull((Object)stdoutFileName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            VertexTaskDetail that = (VertexTaskDetail)o;
            return this.subtask == that.subtask && Objects.equals((Object)this.status, (Object)that.status) && this.attempt == that.attempt && Objects.equals(this.host, that.host) && this.startTime == that.startTime && this.endTime == that.endTime && this.duration == that.duration && Objects.equals(this.metrics, that.metrics) && Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.logFileName, that.logFileName) && Objects.equals(this.stdoutFileName, that.stdoutFileName);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.subtask, this.status, this.attempt, this.host, this.startTime, this.endTime, this.duration, this.metrics, this.resourceId, this.logFileName, this.stdoutFileName});
        }
    }
}

