/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class JobVertexTaskManagersInfo
implements ResponseBody {
    public static final String VERTEX_TASK_FIELD_ID = "id";
    public static final String VERTEX_TASK_FIELD_NAME = "name";
    public static final String VERTEX_TASK_FIELD_NOW = "now";
    public static final String VERTEX_TASK_FIELD_TASK_MANAGERS = "taskmanagers";
    @JsonProperty(value="id")
    @JsonSerialize(using=JobVertexIDSerializer.class)
    private final JobVertexID jobVertexID;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="now")
    private final long now;
    @JsonProperty(value="taskmanagers")
    private Collection<TaskManagersInfo> taskManagerInfos;

    @JsonCreator
    public JobVertexTaskManagersInfo(@JsonDeserialize(using=JobVertexIDDeserializer.class) @JsonProperty(value="id") JobVertexID jobVertexID, @JsonProperty(value="name") String name, @JsonProperty(value="now") long now, @JsonProperty(value="taskmanagers") Collection<TaskManagersInfo> taskManagerInfos) {
        this.jobVertexID = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexID)));
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.now = now;
        this.taskManagerInfos = (Collection)Preconditions.checkNotNull(taskManagerInfos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobVertexTaskManagersInfo that = (JobVertexTaskManagersInfo)o;
        return Objects.equals((Object)this.jobVertexID, (Object)that.jobVertexID) && Objects.equals(this.name, that.name) && this.now == that.now && Objects.equals(this.taskManagerInfos, that.taskManagerInfos);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobVertexID, this.name, this.now, this.taskManagerInfos});
    }

    public static class TaskManagersInfo {
        public static final String TASK_MANAGERS_FIELD_HOST = "host";
        public static final String TASK_MANAGERS_FIELD_STATUS = "status";
        public static final String TASK_MANAGERS_FIELD_START_TIME = "start-time";
        public static final String TASK_MANAGERS_FIELD_END_TIME = "end-time";
        public static final String TASK_MANAGERS_FIELD_DURATION = "duration";
        public static final String TASK_MANAGERS_FIELD_METRICS = "metrics";
        public static final String TASK_MANAGERS_FIELD_STATUS_COUNTS = "status-counts";
        public static final String TASK_MANAGERS_FIELD_RESOURCE_ID = "resource-id";
        @JsonProperty(value="host")
        private final String host;
        @JsonProperty(value="status")
        private final ExecutionState status;
        @JsonProperty(value="start-time")
        private final long startTime;
        @JsonProperty(value="end-time")
        private final long endTime;
        @JsonProperty(value="duration")
        private final long duration;
        @JsonProperty(value="metrics")
        private final IOMetricsInfo metrics;
        @JsonProperty(value="status-counts")
        private final Map<ExecutionState, Integer> statusCounts;
        @JsonProperty(value="resource-id")
        private final String resourceId;

        @JsonCreator
        public TaskManagersInfo(@JsonProperty(value="host") String host, @JsonProperty(value="status") ExecutionState status, @JsonProperty(value="start-time") long startTime, @JsonProperty(value="end-time") long endTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="metrics") IOMetricsInfo metrics, @JsonProperty(value="status-counts") Map<ExecutionState, Integer> statusCounts, @JsonProperty(value="resource-id") String resourceId) {
            this.host = (String)Preconditions.checkNotNull((Object)host);
            this.status = (ExecutionState)((Object)Preconditions.checkNotNull((Object)((Object)status)));
            this.startTime = startTime;
            this.endTime = endTime;
            this.duration = duration;
            this.metrics = (IOMetricsInfo)Preconditions.checkNotNull((Object)metrics);
            this.statusCounts = (Map)Preconditions.checkNotNull(statusCounts);
            this.resourceId = resourceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskManagersInfo that = (TaskManagersInfo)o;
            return Objects.equals(this.host, that.host) && Objects.equals((Object)this.status, (Object)that.status) && this.startTime == that.startTime && this.endTime == that.endTime && this.duration == that.duration && Objects.equals(this.metrics, that.metrics) && Objects.equals(this.statusCounts, that.statusCounts) && Objects.equals(this.resourceId, that.resourceId);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.host, this.status, this.startTime, this.endTime, this.duration, this.metrics, this.statusCounts, this.resourceId});
        }
    }
}

