/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.checkpoints;

import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.rest.messages.checkpoints.MinMaxAvgStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.SubtaskCheckpointStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatistics;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public final class TaskCheckpointStatisticsWithSubtaskDetails
extends TaskCheckpointStatistics {
    public static final String FIELD_NAME_SUMMARY = "summary";
    public static final String FIELD_NAME_SUBTASKS_CHECKPOINT_STATISTICS = "subtasks";
    @JsonProperty(value="summary")
    private final Summary summary;
    @JsonProperty(value="subtasks")
    private final List<SubtaskCheckpointStatistics> subtaskCheckpointStatistics;

    @JsonCreator
    public TaskCheckpointStatisticsWithSubtaskDetails(@JsonProperty(value="id") long checkpointId, @JsonProperty(value="status") CheckpointStatsStatus checkpointStatus, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="full_state_size") long fullStateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonProperty(value="summary") Summary summary, @JsonProperty(value="subtasks") List<SubtaskCheckpointStatistics> subtaskCheckpointStatistics) {
        super(checkpointId, checkpointStatus, latestAckTimestamp, stateSize, fullStateSize, duration, alignmentBuffered, numSubtasks, numAckSubtasks);
        this.summary = (Summary)Preconditions.checkNotNull((Object)summary);
        this.subtaskCheckpointStatistics = (List)Preconditions.checkNotNull(subtaskCheckpointStatistics);
    }

    public Summary getSummary() {
        return this.summary;
    }

    public List<SubtaskCheckpointStatistics> getSubtaskCheckpointStatistics() {
        return this.subtaskCheckpointStatistics;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskCheckpointStatisticsWithSubtaskDetails that = (TaskCheckpointStatisticsWithSubtaskDetails)o;
        return Objects.equals(this.summary, that.summary) && Objects.equals(this.subtaskCheckpointStatistics, that.subtaskCheckpointStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.summary, this.subtaskCheckpointStatistics);
    }

    public static final class CheckpointAlignment {
        public static final String FIELD_NAME_BUFFERED_DATA = "buffered";
        public static final String FIELD_NAME_DURATION = "duration";
        @JsonProperty(value="buffered")
        private final MinMaxAvgStatistics bufferedData;
        @JsonProperty(value="duration")
        private final MinMaxAvgStatistics duration;

        @JsonCreator
        public CheckpointAlignment(@JsonProperty(value="buffered") MinMaxAvgStatistics bufferedData, @JsonProperty(value="duration") MinMaxAvgStatistics duration) {
            this.bufferedData = bufferedData;
            this.duration = duration;
        }

        public MinMaxAvgStatistics getBufferedData() {
            return this.bufferedData;
        }

        public MinMaxAvgStatistics getDuration() {
            return this.duration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckpointAlignment alignment = (CheckpointAlignment)o;
            return Objects.equals(this.bufferedData, alignment.bufferedData) && Objects.equals(this.duration, alignment.duration);
        }

        public int hashCode() {
            return Objects.hash(this.bufferedData, this.duration);
        }
    }

    public static final class CheckpointDuration {
        public static final String FIELD_NAME_SYNCHRONOUS_DURATION = "sync";
        public static final String FIELD_NAME_ASYNCHRONOUS_DURATION = "async";
        @JsonProperty(value="sync")
        private final MinMaxAvgStatistics synchronousDuration;
        @JsonProperty(value="async")
        private final MinMaxAvgStatistics asynchronousDuration;

        @JsonCreator
        public CheckpointDuration(@JsonProperty(value="sync") MinMaxAvgStatistics synchronousDuration, @JsonProperty(value="async") MinMaxAvgStatistics asynchronousDuration) {
            this.synchronousDuration = (MinMaxAvgStatistics)Preconditions.checkNotNull((Object)synchronousDuration);
            this.asynchronousDuration = (MinMaxAvgStatistics)Preconditions.checkNotNull((Object)asynchronousDuration);
        }

        public MinMaxAvgStatistics getSynchronousDuration() {
            return this.synchronousDuration;
        }

        public MinMaxAvgStatistics getAsynchronousDuration() {
            return this.asynchronousDuration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckpointDuration that = (CheckpointDuration)o;
            return Objects.equals(this.synchronousDuration, that.synchronousDuration) && Objects.equals(this.asynchronousDuration, that.asynchronousDuration);
        }

        public int hashCode() {
            return Objects.hash(this.synchronousDuration, this.asynchronousDuration);
        }
    }

    public static final class Summary {
        public static final String FIELD_NAME_STATE_SIZE = "state_size";
        public static final String FIELD_NAME_DURATION = "end_to_end_duration";
        public static final String FIELD_NAME_CHECKPOINT_DURATION = "checkpoint_duration";
        public static final String FIELD_NAME_ALIGNMENT = "alignment";
        @JsonProperty(value="state_size")
        private final MinMaxAvgStatistics stateSize;
        @JsonProperty(value="end_to_end_duration")
        private final MinMaxAvgStatistics duration;
        @JsonProperty(value="checkpoint_duration")
        private final CheckpointDuration checkpointDuration;
        @JsonProperty(value="alignment")
        private final CheckpointAlignment checkpointAlignment;

        @JsonCreator
        public Summary(@JsonProperty(value="state_size") MinMaxAvgStatistics stateSize, @JsonProperty(value="end_to_end_duration") MinMaxAvgStatistics duration, @JsonProperty(value="checkpoint_duration") CheckpointDuration checkpointDuration, @JsonProperty(value="alignment") CheckpointAlignment checkpointAlignment) {
            this.stateSize = (MinMaxAvgStatistics)Preconditions.checkNotNull((Object)stateSize);
            this.duration = (MinMaxAvgStatistics)Preconditions.checkNotNull((Object)duration);
            this.checkpointDuration = (CheckpointDuration)Preconditions.checkNotNull((Object)checkpointDuration);
            this.checkpointAlignment = (CheckpointAlignment)Preconditions.checkNotNull((Object)checkpointAlignment);
        }

        public MinMaxAvgStatistics getStateSize() {
            return this.stateSize;
        }

        public MinMaxAvgStatistics getDuration() {
            return this.duration;
        }

        public CheckpointDuration getCheckpointDuration() {
            return this.checkpointDuration;
        }

        public CheckpointAlignment getCheckpointAlignment() {
            return this.checkpointAlignment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Summary summary = (Summary)o;
            return Objects.equals(this.stateSize, summary.stateSize) && Objects.equals(this.duration, summary.duration) && Objects.equals(this.checkpointDuration, summary.checkpointDuration) && Objects.equals(this.checkpointAlignment, summary.checkpointAlignment);
        }

        public int hashCode() {
            return Objects.hash(this.stateSize, this.duration, this.checkpointDuration, this.checkpointAlignment);
        }
    }
}

