/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class SubtaskExecutionAttemptDetailsInfo
implements ResponseBody {
    public static final String FIELD_NAME_SUBTASK_INDEX = "subtask";
    public static final String FIELD_NAME_STATUS = "status";
    public static final String FIELD_NAME_ATTEMPT = "attempt";
    public static final String FIELD_NAME_HOST = "host";
    public static final String FIELD_NAME_START_TIME = "start-time";
    public static final String FIELD_NAME_END_TIME = "end-time";
    public static final String FIELD_NAME_STATE_TRANSITION_TIME = "state-transition-time";
    public static final String FIELD_NAME_DURATION = "duration";
    public static final String FIELD_NAME_METRICS = "metrics";
    @JsonProperty(value="subtask")
    private final int subtaskIndex;
    @JsonProperty(value="status")
    private final ExecutionState status;
    @JsonProperty(value="attempt")
    private final int attempt;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="start-time")
    private final long startTime;
    @JsonProperty(value="end-time")
    private final long endTime;
    @JsonProperty(value="duration")
    private final long duration;
    @JsonProperty(value="state-transition-time")
    private final Map<ExecutionState, Long> stateTransitionTime;
    @JsonProperty(value="metrics")
    private final IOMetricsInfo ioMetricsInfo;

    @JsonCreator
    public SubtaskExecutionAttemptDetailsInfo(@JsonProperty(value="subtask") int subtaskIndex, @JsonProperty(value="status") ExecutionState status, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="host") String host, @JsonProperty(value="start-time") long startTime, @JsonProperty(value="end-time") long endTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="state-transition-time") Map<ExecutionState, Long> stateTransitionTime, @JsonProperty(value="metrics") IOMetricsInfo ioMetricsInfo) {
        this.subtaskIndex = subtaskIndex;
        this.status = (ExecutionState)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.attempt = attempt;
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.stateTransitionTime = stateTransitionTime;
        this.ioMetricsInfo = (IOMetricsInfo)Preconditions.checkNotNull((Object)ioMetricsInfo);
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public ExecutionState getStatus() {
        return this.status;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public String getHost() {
        return this.host;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public Map<ExecutionState, Long> getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public IOMetricsInfo getIoMetricsInfo() {
        return this.ioMetricsInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtaskExecutionAttemptDetailsInfo that = (SubtaskExecutionAttemptDetailsInfo)o;
        return this.subtaskIndex == that.subtaskIndex && this.status == that.status && this.attempt == that.attempt && Objects.equals(this.host, that.host) && this.startTime == that.startTime && this.endTime == that.endTime && this.duration == that.duration && Objects.equals(this.ioMetricsInfo, that.ioMetricsInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subtaskIndex, this.status, this.attempt, this.host, this.startTime, this.endTime, this.duration, this.ioMetricsInfo});
    }

    public static SubtaskExecutionAttemptDetailsInfo create(AccessExecution execution, MutableIOMetrics ioMetrics) {
        long endTime;
        ExecutionState status = execution.getState();
        long now = System.currentTimeMillis();
        TaskManagerLocation location = execution.getAssignedResourceLocation();
        String locationString = location == null ? "(unassigned)" : location.getHostname() + ":" + location.dataPort();
        long startTime = execution.getStateTimestamp(ExecutionState.DEPLOYING);
        if (startTime == 0L) {
            startTime = -1L;
        }
        long l = endTime = status.isTerminal() ? execution.getStateTimestamp(status) : -1L;
        long duration = startTime > 0L ? (endTime > 0L ? endTime : now) - startTime : -1L;
        IOMetricsInfo ioMetricsInfo = new IOMetricsInfo(ioMetrics);
        long[] stateTimestamps = execution.getStateTimestamps();
        HashMap<ExecutionState, Long> stateTransitionTime = new HashMap<ExecutionState, Long>();
        for (int i = 0; i < stateTimestamps.length; ++i) {
            stateTransitionTime.put(ExecutionState.values()[i], stateTimestamps[i]);
        }
        return new SubtaskExecutionAttemptDetailsInfo(execution.getParallelSubtaskIndex(), status, execution.getAttemptNumber(), locationString, startTime, endTime, duration, stateTransitionTime, ioMetricsInfo);
    }
}

