/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.runtime.jobgraph.ControlType;
import org.apache.flink.runtime.jobgraph.JobControlEdge;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.util.FlinkRuntimeException;

public class ConcurrentJobVertexGroup {
    private List<JobVertex> vertices = new ArrayList<JobVertex>();
    private boolean hasPrecedingGroup = false;
    private boolean hasInputVertex = false;
    private List<JobVertex> predecessorVertices = new ArrayList<JobVertex>();

    public ConcurrentJobVertexGroup(Collection<JobVertex> jobVertices, Set<JobControlEdge> ignoredControlEdges) {
        this.vertices.addAll(this.sortJobVertexTopologically(jobVertices, ignoredControlEdges));
    }

    public List<JobVertex> getVertices() {
        return this.vertices;
    }

    public List<JobVertex> getPredecessorVertices() {
        return this.predecessorVertices;
    }

    public boolean hasPrecedingGroup() {
        return this.hasPrecedingGroup;
    }

    public void noPrecedingGroup() {
        this.hasPrecedingGroup = false;
    }

    public boolean hasInputVertex() {
        return this.hasInputVertex;
    }

    private List<JobVertex> sortJobVertexTopologically(Collection<JobVertex> jobVertices, Set<JobControlEdge> ignoredControlEdges) {
        ArrayList<JobVertex> jobVerticesTopologically = new ArrayList<JobVertex>(jobVertices.size());
        LinkedHashSet<JobVertex> remaining = new LinkedHashSet<JobVertex>(jobVertices);
        while (!remaining.isEmpty()) {
            Iterator iter = remaining.iterator();
            int preSize = remaining.size();
            while (iter.hasNext()) {
                JobVertex jobVertex = (JobVertex)iter.next();
                if (jobVertex.isInputVertex()) {
                    this.hasInputVertex = true;
                }
                boolean allPredecessorAdded = true;
                boolean hasPredecessorInThisGroup = false;
                for (JobEdge jobEdge : jobVertex.getInputs()) {
                    if (jobVertices.contains(jobEdge.getSource().getProducer())) {
                        hasPredecessorInThisGroup = true;
                    }
                    if (!remaining.contains(jobEdge.getSource().getProducer())) continue;
                    allPredecessorAdded = false;
                    break;
                }
                for (JobControlEdge controlEdge : jobVertex.getInControlEdges()) {
                    if (controlEdge.getControlType() != ControlType.START_ON_FINISH || jobVertices.contains(controlEdge.getSource()) || ignoredControlEdges.contains(controlEdge)) continue;
                    this.hasPrecedingGroup = true;
                    this.predecessorVertices.add(controlEdge.getSource());
                }
                if (!hasPredecessorInThisGroup && jobVertex.getNumberOfInputs() > 0) {
                    this.hasPrecedingGroup = true;
                    for (JobEdge jobEdge : jobVertex.getInputs()) {
                        this.predecessorVertices.add(jobEdge.getSource().getProducer());
                    }
                }
                if (!allPredecessorAdded) continue;
                jobVerticesTopologically.add(jobVertex);
                iter.remove();
            }
            if (preSize != remaining.size()) continue;
            throw new FlinkRuntimeException("There are circles among the groups.");
        }
        return jobVerticesTopologically;
    }
}

