/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.schedule;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;

public class ConcurrentSchedulingGroup {
    private final List<ExecutionVertex> executionVertices;
    private final boolean hasPrecedingGroup;
    private final AtomicBoolean scheduled;

    ConcurrentSchedulingGroup(List<ExecutionVertex> executionVertices, boolean hasPrecedingGroup) {
        this(executionVertices, hasPrecedingGroup, false);
    }

    ConcurrentSchedulingGroup(List<ExecutionVertex> executionVertices, boolean hasPrecedingGroup, boolean scheduled) {
        this.executionVertices = executionVertices;
        this.hasPrecedingGroup = hasPrecedingGroup;
        this.scheduled = new AtomicBoolean(scheduled);
    }

    public List<ExecutionVertex> getExecutionVertices() {
        return this.executionVertices;
    }

    public boolean hasPrecedingGroup() {
        return this.hasPrecedingGroup;
    }

    public boolean markScheduled() {
        return this.scheduled.compareAndSet(false, true);
    }
}

