/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.schedule;

import java.util.ArrayList;
import org.apache.flink.runtime.event.ExecutionVertexFailoverEvent;
import org.apache.flink.runtime.event.ExecutionVertexStateChangedEvent;
import org.apache.flink.runtime.event.ResultPartitionConsumableEvent;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.ExecutionSlotAllocator;
import org.apache.flink.runtime.jobmaster.GraphManager;
import org.apache.flink.runtime.schedule.GraphManagerPlugin;
import org.apache.flink.runtime.schedule.SchedulingConfig;
import org.apache.flink.runtime.schedule.VertexScheduler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagerSchedulingPlugin
implements GraphManagerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(EagerSchedulingPlugin.class);
    private VertexScheduler scheduler;
    private JobGraph jobGraph;

    @Override
    public void open(VertexScheduler scheduler, JobGraph jobGraph, SchedulingConfig config, ExecutionGraph eg, GraphManager graphManager, ExecutionSlotAllocator executionSlotAllocator) {
        Preconditions.checkNotNull((Object)config);
        this.scheduler = (VertexScheduler)Preconditions.checkNotNull((Object)scheduler);
        this.jobGraph = (JobGraph)Preconditions.checkNotNull((Object)jobGraph);
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void onSchedulingStarted() {
        ArrayList<ExecutionVertexID> verticesToSchedule = new ArrayList<ExecutionVertexID>();
        for (JobVertex vertex : this.jobGraph.getVerticesSortedTopologicallyFromSources()) {
            for (int i = 0; i < vertex.getParallelism(); ++i) {
                verticesToSchedule.add(new ExecutionVertexID(vertex.getID(), i));
            }
        }
        this.scheduler.scheduleExecutionVertices(verticesToSchedule);
    }

    @Override
    public void onResultPartitionConsumable(ResultPartitionConsumableEvent event) {
        LOG.warn("Ignore the result partition consumable event {} as the schedule mode is EAGER.", (Object)event);
    }

    @Override
    public void onExecutionVertexStateChanged(ExecutionVertexStateChangedEvent event) {
    }

    @Override
    public void onExecutionVertexFailover(ExecutionVertexFailoverEvent event) {
        this.scheduler.scheduleExecutionVertices(event.getAffectedExecutionVertexIDs());
    }

    @Override
    public boolean allowLazyDeployment() {
        return false;
    }
}

