/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateObject;

public class DirectoryStateHandle
implements StateObject {
    private static final long serialVersionUID = 1L;
    @Nonnull
    protected final Path directory;

    public DirectoryStateHandle(@Nonnull Path directory) {
        this.directory = directory;
    }

    @Override
    public void discardState() throws IOException {
        FileSystem fileSystem = this.directory.getFileSystem();
        fileSystem.delete(this.directory, true);
    }

    @Override
    public long getStateSize() {
        return 0L;
    }

    @Nonnull
    public Path getDirectory() {
        return this.directory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryStateHandle that = (DirectoryStateHandle)o;
        return this.directory.equals((Object)that.directory);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    public String toString() {
        return "DirectoryStateHandle{directory=" + this.directory + '}';
    }
}

