/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class PriorityQueueStateMetaInfoSnapshot {
    private final String name;
    private final TypeSerializer<?> elementSerializer;

    public PriorityQueueStateMetaInfoSnapshot(@Nonnull String name, @Nonnull TypeSerializer<?> serializer) {
        this.name = name;
        this.elementSerializer = serializer;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public TypeSerializer<?> getSerializer() {
        return this.elementSerializer;
    }

    public void write(@Nonnull DataOutputView outputView) throws IOException {
        CurrentWriterImpl.INSTANCE.writeStateMetaInfoSnapshot(this, outputView);
    }

    public static PriorityQueueStateMetaInfoSnapshot read(@Nonnull DataInputView inputView, @Nonnull ClassLoader userCodeClassLoader) throws IOException {
        return CurrentReaderImpl.INSTANCE.readStateMetaInfoSnapshot(inputView, userCodeClassLoader);
    }

    public static class CurrentReaderImpl {
        private static final CurrentReaderImpl INSTANCE = new CurrentReaderImpl();

        @Nonnull
        public PriorityQueueStateMetaInfoSnapshot readStateMetaInfoSnapshot(@Nonnull DataInputView inputView, @Nonnull ClassLoader userCodeClassLoader) throws IOException {
            String stateName = inputView.readUTF();
            List serializersWithConfig = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)inputView, (ClassLoader)userCodeClassLoader);
            if (serializersWithConfig.size() >= 1) {
                return new PriorityQueueStateMetaInfoSnapshot(stateName, (TypeSerializer)((Tuple2)serializersWithConfig.get((int)0)).f0);
            }
            throw new IOException("unexpected snapshot for PriorityQueueStateMetaInfoSnapshot");
        }
    }

    public static class CurrentWriterImpl {
        private static final CurrentWriterImpl INSTANCE = new CurrentWriterImpl();

        public void writeStateMetaInfoSnapshot(@Nonnull PriorityQueueStateMetaInfoSnapshot snapshot, @Nonnull DataOutputView outputView) throws IOException {
            outputView.writeUTF(snapshot.name);
            ArrayList<Tuple2> serializersWithConfig = new ArrayList<Tuple2>(1);
            serializersWithConfig.add(new Tuple2((Object)snapshot.elementSerializer, (Object)snapshot.elementSerializer.snapshotConfiguration()));
            TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)outputView, serializersWithConfig);
        }
    }
}

