/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.PriorityQueueStateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

public class RegisteredPriorityQueueStateBackendMetaInfo<T> {
    @Nonnull
    protected final String name;
    @Nonnull
    private final TypeSerializer<T> elementSerializer;

    public RegisteredPriorityQueueStateBackendMetaInfo(@Nonnull String name, @Nonnull TypeSerializer<T> elementSerializer) {
        this.name = name;
        this.elementSerializer = elementSerializer;
    }

    public RegisteredPriorityQueueStateBackendMetaInfo(PriorityQueueStateMetaInfoSnapshot snapshot) {
        this(snapshot.getName(), (TypeSerializer)Preconditions.checkNotNull(snapshot.getSerializer()));
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public PriorityQueueStateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Nonnull
    public TypeSerializer<T> getElementSerializer() {
        return this.elementSerializer;
    }

    private PriorityQueueStateMetaInfoSnapshot computeSnapshot() {
        return new PriorityQueueStateMetaInfoSnapshot(this.name, this.elementSerializer.duplicate());
    }

    public RegisteredPriorityQueueStateBackendMetaInfo deepCopy() {
        return new RegisteredPriorityQueueStateBackendMetaInfo<T>(this.name, this.elementSerializer.duplicate());
    }
}

