/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StateSerializerUtil;
import org.apache.flink.types.Pair;

public class StateIteratorUtil {
    public static <K> Iterator<K> createKeyIterator(final Iterator<Pair<byte[], byte[]>> innerIterator, final TypeSerializer<K> keySerializer, final int stateNameByteLength) {
        return new Iterator<K>(){

            @Override
            public boolean hasNext() {
                return innerIterator.hasNext();
            }

            @Override
            public K next() {
                byte[] serializedKey = (byte[])((Pair)innerIterator.next()).getKey();
                try {
                    return StateSerializerUtil.getDeserializedKeyForKeyedValueState(serializedKey, keySerializer, stateNameByteLength);
                }
                catch (IOException e) {
                    throw new StateAccessException(e);
                }
            }

            @Override
            public void remove() {
                innerIterator.remove();
            }
        };
    }
}

