/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Comparator;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.PriorityComparator;
import org.apache.flink.util.FlinkRuntimeException;

public class TieBreakingPriorityComparator<T>
implements Comparator<T>,
PriorityComparator<T> {
    @Nonnull
    private final PriorityComparator<T> priorityComparator;
    @Nonnull
    private final TypeSerializer<T> serializer;
    @Nonnull
    private final ByteArrayOutputStreamWithPos outStream;
    @Nonnull
    private final DataOutputViewStreamWrapper outView;

    public TieBreakingPriorityComparator(@Nonnull PriorityComparator<T> priorityComparator, @Nonnull TypeSerializer<T> serializer, @Nonnull ByteArrayOutputStreamWithPos outStream, @Nonnull DataOutputViewStreamWrapper outView) {
        this.priorityComparator = priorityComparator;
        this.serializer = serializer;
        this.outStream = outStream;
        this.outView = outView;
    }

    @Override
    public int compare(T o1, T o2) {
        int cmp = this.priorityComparator.comparePriority(o1, o2);
        if (cmp != 0) {
            return cmp;
        }
        if (o1 instanceof Comparable && o1.getClass().equals(o2.getClass())) {
            return ((Comparable)o1).compareTo(o2);
        }
        try {
            this.outStream.reset();
            this.serializer.serialize(o1, (DataOutputView)this.outView);
            int leftLen = this.outStream.getPosition();
            this.serializer.serialize(o2, (DataOutputView)this.outView);
            int rightLen = this.outStream.getPosition() - leftLen;
            return TieBreakingPriorityComparator.compareBytes(this.outStream.getBuf(), 0, leftLen, leftLen, rightLen);
        }
        catch (IOException ex) {
            throw new FlinkRuntimeException("Serializer problem in comparator.", (Throwable)ex);
        }
    }

    @Override
    public int comparePriority(T left, T right) {
        return this.priorityComparator.comparePriority(left, right);
    }

    public static int compareBytes(byte[] bytes, int offLeft, int leftLen, int offRight, int rightLen) {
        int maxLen = Math.min(leftLen, rightLen);
        for (int i = 0; i < maxLen; ++i) {
            int cmp = bytes[offLeft + i] - bytes[offRight + i];
            if (cmp == 0) continue;
            return cmp;
        }
        return leftLen - rightLen;
    }
}

