/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.context.ContextKeyedState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedState;

public class ContextMapState<K, UK, UV>
implements ContextKeyedState<K, Map<UK, UV>>,
InternalMapState<K, VoidNamespace, UK, UV> {
    private final KeyContextImpl<K> keyContext;
    private final KeyedMapState<Object, UK, UV> keyedState;

    public ContextMapState(KeyContextImpl<K> keyContext, KeyedMapState<Object, UK, UV> keyedState) {
        this.keyContext = keyContext;
        this.keyedState = keyedState;
    }

    public void clear() {
        this.keyedState.remove(this.keyContext.getCurrentKey());
    }

    public UV get(UK key) {
        return (UV)this.keyedState.get(this.keyContext.getCurrentKey(), key);
    }

    public void put(UK key, UV value) {
        this.keyedState.add(this.keyContext.getCurrentKey(), key, value);
    }

    public void putAll(Map<UK, UV> map) {
        this.keyedState.addAll(this.keyContext.getCurrentKey(), map);
    }

    public void remove(UK key) {
        this.keyedState.remove(this.keyContext.getCurrentKey(), key);
    }

    public boolean contains(UK key) {
        return this.keyedState.contains(this.keyContext.getCurrentKey(), key);
    }

    public Iterable<Map.Entry<UK, UV>> entries() {
        Iterator iterator = this.keyedState.iterator(this.keyContext.getCurrentKey());
        if (!iterator.hasNext()) {
            return null;
        }
        return () -> iterator;
    }

    public Iterable<UK> keys() {
        final Iterator entryIterator = this.keyedState.iterator(this.keyContext.getCurrentKey());
        Iterator keyIterator = new Iterator<UK>(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public UK next() {
                return ((Map.Entry)entryIterator.next()).getKey();
            }

            @Override
            public void remove() {
                entryIterator.remove();
            }
        };
        return () -> keyIterator;
    }

    public Iterable<UV> values() {
        final Iterator entryIterator = this.keyedState.iterator(this.keyContext.getCurrentKey());
        Iterator valueIterator = new Iterator<UV>(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public UV next() {
                return ((Map.Entry)entryIterator.next()).getValue();
            }
        };
        return () -> valueIterator;
    }

    public Iterator<Map.Entry<UK, UV>> iterator() {
        return this.keyedState.iterator(this.keyContext.getCurrentKey());
    }

    @Override
    public KeyedState getKeyedState() {
        return this.keyedState;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keyContext.getKeySerializer();
    }

    @Override
    public TypeSerializer<Map<UK, UV>> getValueSerializer() {
        return this.keyedState.getDescriptor().getValueSerializer();
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer safeKeySerializer, TypeSerializer safeNamespaceSerializer, TypeSerializer safeValueSerializer) throws Exception {
        return this.keyedState.getSerializedValue(serializedKeyAndNamespace, safeKeySerializer, safeValueSerializer);
    }
}

