/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.context.ContextSubKeyedState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedState;
import org.apache.flink.util.Preconditions;

public class ContextSubKeyedMapState<K, N, UK, UV>
implements ContextSubKeyedState<K, N, Map<UK, UV>>,
InternalMapState<K, N, UK, UV> {
    private N namespace;
    private final KeyContextImpl<K> operator;
    private final SubKeyedMapState<Object, N, UK, UV> subKeyedMapState;

    public ContextSubKeyedMapState(KeyContextImpl<K> operator, SubKeyedMapState<Object, N, UK, UV> subKeyedMapState) {
        Preconditions.checkNotNull(operator);
        Preconditions.checkNotNull(subKeyedMapState);
        this.operator = operator;
        this.subKeyedMapState = subKeyedMapState;
    }

    public UV get(UK key) throws Exception {
        return (UV)this.subKeyedMapState.get(this.operator.getCurrentKey(), this.namespace, key);
    }

    public void put(UK key, UV value) throws Exception {
        this.subKeyedMapState.add(this.operator.getCurrentKey(), this.namespace, key, value);
    }

    public void putAll(Map<UK, UV> map) throws Exception {
        this.subKeyedMapState.addAll(this.operator.getCurrentKey(), this.namespace, map);
    }

    public void remove(UK key) throws Exception {
        this.subKeyedMapState.remove(this.operator.getCurrentKey(), this.namespace, key);
    }

    public boolean contains(UK key) throws Exception {
        return this.subKeyedMapState.contains(this.operator.getCurrentKey(), this.namespace, key);
    }

    public Iterable<Map.Entry<UK, UV>> entries() throws Exception {
        Iterator iterator = this.subKeyedMapState.iterator(this.operator.getCurrentKey(), this.namespace);
        return () -> iterator;
    }

    public Iterable<UK> keys() throws Exception {
        final Iterator entryIterator = this.subKeyedMapState.iterator(this.operator.getCurrentKey(), this.namespace);
        Iterator keyIterator = new Iterator<UK>(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public UK next() {
                return ((Map.Entry)entryIterator.next()).getKey();
            }
        };
        return () -> keyIterator;
    }

    public Iterable<UV> values() throws Exception {
        final Iterator entryIterator = this.subKeyedMapState.iterator(this.operator.getCurrentKey(), this.namespace);
        Iterator valueIterator = new Iterator<UV>(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public UV next() {
                return ((Map.Entry)entryIterator.next()).getValue();
            }
        };
        return () -> valueIterator;
    }

    public Iterator<Map.Entry<UK, UV>> iterator() throws Exception {
        return this.subKeyedMapState.iterator(this.operator.getCurrentKey(), this.namespace);
    }

    public void clear() {
        this.subKeyedMapState.remove(this.operator.getCurrentKey(), this.namespace);
    }

    @Override
    public SubKeyedState getSubKeyedState() {
        return this.subKeyedMapState;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.operator.getKeySerializer();
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.subKeyedMapState.getDescriptor().getNamespaceSerializer();
    }

    @Override
    public TypeSerializer<Map<UK, UV>> getValueSerializer() {
        return this.subKeyedMapState.getDescriptor().getValueSerializer();
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        this.namespace = namespace;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<Map<UK, UV>> safeValueSerializer) throws Exception {
        return new byte[0];
    }
}

