/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.io.IOException;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.context.ContextKeyedState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.util.Preconditions;

public class ContextValueState<K, V>
implements ContextKeyedState<K, V>,
InternalValueState<K, VoidNamespace, V> {
    private final KeyContextImpl<K> keyContext;
    private final KeyedValueState<Object, V> keyedState;
    private final ValueStateDescriptor<V> stateDescriptor;

    public ContextValueState(KeyContextImpl<K> operator, KeyedValueState<Object, V> keyedState, ValueStateDescriptor<V> stateDescriptor) {
        Preconditions.checkNotNull(operator);
        Preconditions.checkNotNull(keyedState);
        Preconditions.checkNotNull(stateDescriptor);
        this.keyContext = operator;
        this.keyedState = keyedState;
        this.stateDescriptor = stateDescriptor;
    }

    public V value() throws IOException {
        K key = this.keyContext.getCurrentKey();
        Preconditions.checkNotNull(key, (String)"No key set. This method should not be called outside of a keyed context.");
        Object value = this.keyedState.get(key);
        return (V)(value == null ? this.stateDescriptor.getDefaultValue() : value);
    }

    public void update(V value) throws IOException {
        if (value == null) {
            this.clear();
        } else {
            this.keyedState.put(this.keyContext.getCurrentKey(), value);
        }
    }

    public void clear() {
        this.keyedState.remove(this.keyContext.getCurrentKey());
    }

    @Override
    public KeyedState getKeyedState() {
        return this.keyedState;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keyContext.getKeySerializer();
    }

    @Override
    public TypeSerializer<V> getValueSerializer() {
        return this.keyedState.getDescriptor().getValueSerializer();
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer safeKeySerializer, TypeSerializer safeNamespaceSerializer, TypeSerializer safeValueSerializer) throws Exception {
        return this.keyedState.getSerializedValue(serializedKeyAndNamespace, (TypeSerializer<Object>)safeKeySerializer, safeValueSerializer);
    }
}

