/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class FileSegmentStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = 1L;
    private final Path filePath;
    private final long startPosition;
    private final long endPosition;
    private final long stateSize;
    private final boolean fileClosed;

    public FileSegmentStateHandle(Path filePath, long startPosition, long endPosition, boolean fileClosed) {
        Preconditions.checkArgument((startPosition >= 0L && endPosition >= startPosition ? 1 : 0) != 0, (Object)("Illegal startPosition: " + startPosition + " and endPosition:" + endPosition));
        this.filePath = filePath;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.stateSize = endPosition - startPosition;
        this.fileClosed = fileClosed;
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        FSDataInputStream inputStream = this.getFileSystem().open(this.filePath);
        inputStream.seek(this.startPosition);
        return inputStream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSegmentStateHandle that = (FileSegmentStateHandle)o;
        return this.filePath.equals((Object)that.filePath) && this.startPosition == that.startPosition && this.endPosition == that.endPosition && this.fileClosed == that.fileClosed;
    }

    public int hashCode() {
        int result = this.filePath.hashCode();
        result = 31 * result + (int)(this.startPosition ^ this.startPosition >>> 32);
        result = 31 * result + (int)(this.endPosition ^ this.endPosition >>> 32);
        result = 31 * result + Objects.hashCode(this.fileClosed);
        return result;
    }

    public String toString() {
        return "FileSegmentStateHandle{filePath=" + this.filePath + ", startPosition=" + this.startPosition + ", endPosition=" + this.endPosition + ", stateSize=" + this.getStateSize() + ", fileClosed=" + this.fileClosed + "}";
    }

    @Override
    public void discardState() throws Exception {
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public long getEndPosition() {
        return this.endPosition;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public SharedStateRegistryKey getRegistryKey() {
        return new SharedStateRegistryKey(this.filePath.toString());
    }

    public boolean isFileClosed() {
        return this.fileClosed;
    }

    private FileSystem getFileSystem() throws IOException {
        return FileSystem.get((URI)this.filePath.toUri());
    }
}

