/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCompletedCheckpointStorageLocation;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FsCheckpointMetadataOutputStream
extends CheckpointMetadataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(FsCheckpointMetadataOutputStream.class);
    private final FSDataOutputStream out;
    private final Path metadataFilePath;
    private final Path tmpMetadataFilePath;
    private final Path exclusiveCheckpointDir;
    private final FileSystem fileSystem;
    private volatile boolean closed;

    public FsCheckpointMetadataOutputStream(FileSystem fileSystem, Path metadataFilePath, Path exclusiveCheckpointDir) throws IOException {
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.metadataFilePath = (Path)Preconditions.checkNotNull((Object)metadataFilePath);
        this.exclusiveCheckpointDir = (Path)Preconditions.checkNotNull((Object)exclusiveCheckpointDir);
        if (fileSystem.exists(metadataFilePath)) {
            throw new IOException("the meta file " + metadataFilePath + " already exists.");
        }
        this.tmpMetadataFilePath = FsCheckpointMetadataOutputStream.getTempMetaPath(metadataFilePath);
        this.out = fileSystem.create(this.tmpMetadataFilePath, FileSystem.WriteMode.NO_OVERWRITE);
    }

    public final void write(int b) throws IOException {
        this.out.write(b);
    }

    public final void write(@Nonnull byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public long getPos() throws IOException {
        return this.out.getPos();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void sync() throws IOException {
        this.out.sync();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.out.close();
            }
            catch (Throwable t) {
                LOG.warn("Could not close the state stream for {}.", (Object)this.tmpMetadataFilePath, (Object)t);
            }
            this.closeFilesQuietly();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FsCompletedCheckpointStorageLocation closeAndFinalizeCheckpoint() throws IOException {
        FsCheckpointMetadataOutputStream fsCheckpointMetadataOutputStream = this;
        synchronized (fsCheckpointMetadataOutputStream) {
            if (this.closed) {
                throw new IOException("Stream has already been closed and discarded.");
            }
            try {
                long size = 0L;
                try {
                    size = this.out.getPos();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.out.close();
                this.fileSystem.rename(this.tmpMetadataFilePath, this.metadataFilePath);
                FileStateHandle metaDataHandle = new FileStateHandle(this.metadataFilePath, size);
                FsCompletedCheckpointStorageLocation fsCompletedCheckpointStorageLocation = new FsCompletedCheckpointStorageLocation(this.fileSystem, this.exclusiveCheckpointDir, metaDataHandle, this.exclusiveCheckpointDir.toString());
                return fsCompletedCheckpointStorageLocation;
            }
            catch (Exception e) {
                this.closeFilesQuietly();
                throw new IOException("Could not flush and close the file system output stream to " + this.tmpMetadataFilePath + " and rename it to " + this.metadataFilePath + "in order to obtain the stream state handle", e);
            }
            finally {
                this.closed = true;
            }
        }
    }

    private void closeFilesQuietly() {
        try {
            if (this.fileSystem.exists(this.tmpMetadataFilePath)) {
                this.fileSystem.delete(this.tmpMetadataFilePath, false);
            }
        }
        catch (Throwable t) {
            LOG.warn("Could not delete the checkpoint stream file(the temp meta file) {}.", (Object)this.tmpMetadataFilePath, (Object)t);
        }
        try {
            if (this.fileSystem.exists(this.metadataFilePath)) {
                this.fileSystem.delete(this.metadataFilePath, false);
            }
        }
        catch (Throwable t) {
            LOG.warn("Could not delete the meta file {}.", (Object)this.metadataFilePath, (Object)t);
        }
    }

    @VisibleForTesting
    static Path getTempMetaPath(Path path) {
        return new Path(path.getParent(), "_tmp_" + path.getName());
    }
}

