/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorage;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.util.Preconditions;

public class FsCheckpointStorage
extends AbstractFsCheckpointStorage {
    private final FileSystem fileSystem;
    private final Path checkpointsDirectory;
    private final Path exclusiveStateDirectory;
    private final Path sharedStateDirectory;
    private final Path taskOwnedStateDirectory;
    private final int fileSizeThreshold;
    private final int writeBufferSize;
    private int stateSubDirs;

    public FsCheckpointStorage(Path checkpointBaseDirectory, @Nullable Path defaultSavepointDirectory, JobID jobId, boolean createCheckpointSubDir, int fileSizeThreshold, int writeBufferSize) throws IOException {
        super(jobId, defaultSavepointDirectory);
        Preconditions.checkArgument((fileSizeThreshold >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((writeBufferSize >= 0 ? 1 : 0) != 0);
        this.fileSystem = checkpointBaseDirectory.getFileSystem();
        this.checkpointsDirectory = createCheckpointSubDir ? FsCheckpointStorage.getCheckpointDirectoryForJob(checkpointBaseDirectory, jobId) : checkpointBaseDirectory;
        this.exclusiveStateDirectory = new Path(this.checkpointsDirectory, "exclusive");
        this.sharedStateDirectory = new Path(this.checkpointsDirectory, "shared");
        this.taskOwnedStateDirectory = new Path(this.checkpointsDirectory, "taskowned");
        this.fileSizeThreshold = fileSizeThreshold;
        this.writeBufferSize = writeBufferSize;
        this.stateSubDirs = 0;
        this.fileSystem.mkdirs(this.checkpointsDirectory);
        this.fileSystem.mkdirs(this.exclusiveStateDirectory);
        this.fileSystem.mkdirs(this.sharedStateDirectory);
        this.fileSystem.mkdirs(this.taskOwnedStateDirectory);
    }

    public Path getCheckpointsDirectory() {
        return this.checkpointsDirectory;
    }

    public void setStateSubDirs(int stateSubDirs) {
        Preconditions.checkArgument((stateSubDirs >= 0 ? 1 : 0) != 0, (Object)"assigned state sub-directories number cannot be less than zero.");
        this.stateSubDirs = stateSubDirs;
    }

    public int getStateSubDirs() {
        return this.stateSubDirs;
    }

    @Override
    public boolean supportsHighlyAvailableStorage() {
        return true;
    }

    @Override
    public CheckpointStorageLocation initializeLocationForCheckpoint(long checkpointId) throws IOException {
        Preconditions.checkArgument((checkpointId >= 0L ? 1 : 0) != 0);
        Path checkpointDir = FsCheckpointStorage.createCheckpointDirectory(this.checkpointsDirectory, checkpointId);
        this.fileSystem.mkdirs(checkpointDir);
        return new FsCheckpointStorageLocation(this.fileSystem, checkpointDir, this.exclusiveStateDirectory, this.sharedStateDirectory, this.taskOwnedStateDirectory, CheckpointStorageLocationReference.getDefault(), this.fileSizeThreshold, this.writeBufferSize);
    }

    @Override
    public CheckpointStreamFactory resolveCheckpointStorageLocation(long checkpointId, CheckpointStorageLocationReference reference) throws IOException {
        if (reference.isDefaultReference()) {
            Path checkpointDir = FsCheckpointStorage.createCheckpointDirectory(this.checkpointsDirectory, checkpointId);
            if (this.stateSubDirs > 0) {
                return new FsCheckpointStorageLocation(this.fileSystem, checkpointDir, new Path(this.exclusiveStateDirectory, String.valueOf(ThreadLocalRandom.current().nextInt(this.stateSubDirs))), new Path(this.sharedStateDirectory, String.valueOf(ThreadLocalRandom.current().nextInt(this.stateSubDirs))), new Path(this.taskOwnedStateDirectory, String.valueOf(ThreadLocalRandom.current().nextInt(this.stateSubDirs))), reference, this.fileSizeThreshold, this.writeBufferSize);
            }
            return new FsCheckpointStorageLocation(this.fileSystem, checkpointDir, this.exclusiveStateDirectory, this.sharedStateDirectory, this.taskOwnedStateDirectory, reference, this.fileSizeThreshold, this.writeBufferSize);
        }
        Path path = FsCheckpointStorage.decodePathFromReference(reference);
        return new FsCheckpointStorageLocation(path.getFileSystem(), path, path, path, path, reference, this.fileSizeThreshold, this.writeBufferSize);
    }

    @Override
    public CheckpointStreamFactory.CheckpointStateOutputStream createTaskOwnedStateStream() throws IOException {
        return new FsCheckpointStreamFactory.FsCheckpointStateOutputStream(this.taskOwnedStateDirectory, this.fileSystem, -1L, this.writeBufferSize, this.fileSizeThreshold);
    }

    @Override
    protected CheckpointStorageLocation createSavepointLocation(FileSystem fs, Path location) throws IOException {
        CheckpointStorageLocationReference reference = FsCheckpointStorage.encodePathAsReference(location);
        return new FsCheckpointStorageLocation(fs, location, location, location, location, reference, this.fileSizeThreshold, this.writeBufferSize);
    }
}

