/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.state.gemini.engine.filecache.FileCache;

public class GeminiOptions {
    private static final String KEY_PREFIX_NAME = "state.backend.gemini";
    public static final ConfigOption<String> DFS_PATH = ConfigOptions.key((String)GeminiOptions.buildKey("dfs.dir")).noDefaultValue().withDescription("The dfs directory where GeminiDB puts its files.");
    public static final ConfigOption<String> LOCAL_PATH = ConfigOptions.key((String)GeminiOptions.buildKey("local.dir")).noDefaultValue().withDescription("The local directory (on the TaskManager) where GeminiDB puts its files.");
    public static final ConfigOption<Integer> SAMPLE_COUNT = ConfigOptions.key((String)GeminiOptions.buildKey("metric.sample.count")).defaultValue((Object)100).withDescription("The sampling rate of state related metrics based on action count.");
    public static final ConfigOption<Integer> HISTOGRAM_WINDOW_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("metric.histogram.window")).defaultValue((Object)5).withDescription("The window size used for state histogram metrics.");
    public static final ConfigOption<Integer> REGION_THREAD_NUM = ConfigOptions.key((String)GeminiOptions.buildKey("region.thread.num")).defaultValue((Object)4).withDescription("Number of threads used to add, update and remove pages from PageStores.Multiple regions may share a thread.");
    public static final ConfigOption<Integer> FLUSH_THREAD_NUM = ConfigOptions.key((String)GeminiOptions.buildKey("flush.thread.num")).defaultValue((Object)4).withDescription("Number of threads used to flush pages to files.");
    public static final ConfigOption<Boolean> USE_OFFHEAP = ConfigOptions.key((String)GeminiOptions.buildKey("use.offheap")).defaultValue((Object)false).withDescription("Whether to use off-heap.");
    public static final ConfigOption<Boolean> USE_OFFHEAP_FOR_READ = ConfigOptions.key((String)GeminiOptions.buildKey("use.offheap.for-read")).defaultValue((Object)false).withDescription("Whether to use off-heap when reading data from local files.");
    public static final ConfigOption<String> HEAP_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("heap.size")).noDefaultValue().withDescription("Size of heap that backend can use, and must be positive.");
    public static final ConfigOption<String> OFFHEAP_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("offheap.size")).noDefaultValue().withDescription("Size of offheap that backend can use, and must be positive.");
    public static final ConfigOption<Float> MEMORY_RATIO = ConfigOptions.key((String)GeminiOptions.buildKey("memory.ratio")).defaultValue((Object)Float.valueOf(0.5f)).withDescription("Ratio of memory used by DB relative to JVM's heap/offheap. This option only works when " + HEAP_SIZE.key() + " or " + OFFHEAP_SIZE.key() + " is not set.");
    public static final ConfigOption<Float> TOTAL_WRITEBUFFER_RATE = ConfigOptions.key((String)GeminiOptions.buildKey("total.writebuffer.rate")).defaultValue((Object)Float.valueOf(0.05f)).withDescription("Ratio of memory usage for all writebuffers relative to JVM heap.");
    public static final ConfigOption<String> WRITE_BUFFER_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("writebuffer.size")).defaultValue((Object)"640kb").withDescription("Amount of data for a region to store in memory before they are flushed to file.");
    public static final ConfigOption<Integer> HUGE_PAGE_THRESHOLD = ConfigOptions.key((String)GeminiOptions.buildKey("huge.page.threshold")).defaultValue((Object)393216).withDescription("Page will be treated a huge page if it's size exceeds this threshold.");
    public static final ConfigOption<Float> TOTAL_HEAP_LOW_MARK_RATE = ConfigOptions.key((String)GeminiOptions.buildKey("total.heap.low_mark.rate")).defaultValue((Object)Float.valueOf(0.6f)).withDescription("Try to fill sample pool if memory usage exceeds this watermark.");
    public static final ConfigOption<Float> TOTAL_HEAP_MIDDLE_MARK_RATE = ConfigOptions.key((String)GeminiOptions.buildKey("total.heap.middle_mark.rate")).defaultValue((Object)Float.valueOf(0.65f)).withDescription("Some pages will be flushed if memory usage exceeds this watermark.");
    public static final ConfigOption<Float> TOTAL_HEAP_HIGH_MARK_RATE = ConfigOptions.key((String)GeminiOptions.buildKey("total.heap.high_mark.rate")).defaultValue((Object)Float.valueOf(0.7f)).withDescription("Some pages will be evicted if memory usage exceeds this watermark.");
    public static final ConfigOption<Integer> ALLOCATOR_DIRECT_ARENA = ConfigOptions.key((String)GeminiOptions.buildKey("allocator.direct.arena.num")).defaultValue((Object)8).withDescription("Number of direct arenas for netty allocator.");
    public static final ConfigOption<Integer> FLUSHING_SEGMENT = ConfigOptions.key((String)GeminiOptions.buildKey("flushing.segment.num")).defaultValue((Object)3).withDescription("Maximum number of flushing segment to allow for each region.");
    public static final ConfigOption<Float> FLUSHING_SEGMENT_RATIO = ConfigOptions.key((String)GeminiOptions.buildKey("flushing.segment.total.ratio")).defaultValue((Object)Float.valueOf(1.0f)).withDescription("This option limits the total number of allowed flushing segments in all regions together with " + FLUSHING_SEGMENT.key() + ". For example, if DB is responsible for 10 regions, " + FLUSHING_SEGMENT.key() + " is set to 3 and this option is set to 1.0, total number of allowed flushingsegments will be 30, but if this option is set to 0.5, total number of allowed flushing segments will be 15.");
    public static final ConfigOption<Integer> READ_LRU_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("read.lru.size")).defaultValue((Object)1024).withDescription("Size of LRU cache.");
    public static final ConfigOption<Integer> MAX_PREPARED_FLUSH_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("max.prepared.flush.size")).defaultValue((Object)0x200000).withDescription("Max size of prepared pages, default is 2MB.");
    public static final ConfigOption<Integer> EVICT_POOL_FACTOR = ConfigOptions.key((String)GeminiOptions.buildKey("evict.pool.factor")).defaultValue((Object)20).withDescription("Ratio of pool size relative to " + MAX_PREPARED_FLUSH_SIZE.key() + " .");
    public static final ConfigOption<Integer> CACHE_TIME_PER_TICK = ConfigOptions.key((String)GeminiOptions.buildKey("time.per.tick.second")).defaultValue((Object)20).withDescription("Time in second per tick for scoring pages.");
    public static final ConfigOption<Integer> SORTED_LIST_COUNT_FOR_FLUSH = ConfigOptions.key((String)GeminiOptions.buildKey("evict.page.pool.sorted.list.min.count")).defaultValue((Object)16).withDescription("a sorted list is generated by sorting evict sample pool, we don't use all of the items in this list for best-effort finding the colder page.");
    public static final ConfigOption<Integer> VM_PRINT_TICK = ConfigOptions.key((String)GeminiOptions.buildKey("vm.print.tick")).defaultValue((Object)30).withDescription("the number of ticks, after which to print the vm info.");
    public static final ConfigOption<Boolean> VM_PRINT_AUDIT_INFO = ConfigOptions.key((String)GeminiOptions.buildKey("vm.print.audit.info")).defaultValue((Object)false).withDescription("for DEV debug.");
    public static final ConfigOption<Boolean> VM_EVICT_BASE_ON_COMPOSITE_PAGE_ADDRESS = ConfigOptions.key((String)GeminiOptions.buildKey("evict.base.on.composite.page.address")).defaultValue((Object)true).withDescription("evict add PageAddressComposite into sample pool.");
    public static final ConfigOption<Integer> BUCKET_INIT_NUM = ConfigOptions.key((String)GeminiOptions.buildKey("bucket.init.num")).defaultValue((Object)1).withDescription("Initial number of buckets in page index.");
    public static final ConfigOption<Integer> SPLIT_SIZE_THRESHOLD = ConfigOptions.key((String)GeminiOptions.buildKey("split.size.threshold")).defaultValue((Object)16384).withDescription("Threshold of bucket size to split");
    public static final ConfigOption<Integer> INDEX_COUNT_HIGH_MARK = ConfigOptions.key((String)GeminiOptions.buildKey("index.count.high.mark")).defaultValue((Object)524288).withDescription("Split will be forbidden if total number of buckets exceeds this watermark");
    public static final ConfigOption<Integer> INDEX_COUNT_LOW_MARK = ConfigOptions.key((String)GeminiOptions.buildKey("index.count.low.mark")).defaultValue((Object)262144).withDescription("Currently this watermark is just for monitor.");
    public static final ConfigOption<Integer> COMPACTION_THREAD_NUM = ConfigOptions.key((String)GeminiOptions.buildKey("compaction.thread.num")).defaultValue((Object)4).withDescription("Number of threads used to compaction pages.");
    public static final ConfigOption<Integer> MINOR_COMPACTION_THRESHOLD = ConfigOptions.key((String)GeminiOptions.buildKey("minor.compaction.threshold")).defaultValue((Object)3).withDescription("A minor compaction will be triggered if the number of continuous in-memory pages in a logical page chain reaches the threshold.");
    public static final ConfigOption<Integer> MINOR_COMPACTION_MAX_RUNNING = ConfigOptions.key((String)GeminiOptions.buildKey("minor.compaction.max-running")).defaultValue((Object)128).withDescription("Max number of running minor compactions.");
    public static final ConfigOption<Integer> MAJOR_COMPACTION_THRESHOLD = ConfigOptions.key((String)GeminiOptions.buildKey("major.compaction.threshold")).defaultValue((Object)5).withDescription("A major compaction will be triggered if the number of pages in a logical page chain reaches the threshold.");
    public static final ConfigOption<Integer> MAJOR_COMPACTION_MAX_RUNNING = ConfigOptions.key((String)GeminiOptions.buildKey("major.compaction.max-running")).defaultValue((Object)8).withDescription("Max number of running major compactions.");
    public static final ConfigOption<Integer> LOGIC_CHAIN_INIT_LEN = ConfigOptions.key((String)GeminiOptions.buildKey("logical.page.chain.init.len")).defaultValue((Object)3).withDescription("Initial length of logical page chain.");
    public static final ConfigOption<Integer> LRU_INTO_MAIN_CACHE_THREAD_NUM = ConfigOptions.key((String)GeminiOptions.buildKey("lru.into.main-cache.thread.num")).defaultValue((Object)2).withDescription("Thread number used to fetch data from LRU to main cache.");
    public static final ConfigOption<Integer> LRU_INTO_MAIN_CACHE_SLEEP_MS = ConfigOptions.key((String)GeminiOptions.buildKey("lru.into.main-cache.sleep.ms")).defaultValue((Object)5000).withDescription("The minimal millsecond will sleep between two operations between fetch data from lru to main cache.");
    public static final ConfigOption<Boolean> LRU_ADD_INTO_MAIN_WHEN_SPLITTING = ConfigOptions.key((String)GeminiOptions.buildKey("lru.add-into-main.when.split")).defaultValue((Object)true).withDescription("Whether fetch data from lru into main cache when pagechain is splitting.");
    public static final ConfigOption<Boolean> ENABLE_LRU_INTO_MAIN_CACHE = ConfigOptions.key((String)GeminiOptions.buildKey("enable.lru-into-main")).defaultValue((Object)false).withDescription("Whether enable to load page from lru into main cache");
    public static final ConfigOption<Boolean> ENABLE_LRU_ACCESS_MODE = ConfigOptions.key((String)GeminiOptions.buildKey("enable.lru.access-mode")).defaultValue((Object)false).withDescription("Whether change the lru cache order when access an entry in the cache");
    public static final ConfigOption<Boolean> LRU_CACHE_EVEN_EVICT = ConfigOptions.key((String)GeminiOptions.buildKey("enable.lru.even-evict")).defaultValue((Object)false).withDescription("Whether evict all region evenly.");
    public static final ConfigOption<String> MAX_FILE_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("file.max-size")).defaultValue((Object)"128mb").withDescription("Maximum size of data file. File will be closed for write if it's size reaches this target.");
    public static final ConfigOption<Long> FILE_ALIVE_TIME_AFTER_NO_DATA_REFERENCE = ConfigOptions.key((String)GeminiOptions.buildKey("file.alive.time.after.no.data.reference.ms")).defaultValue((Object)30000L).withDescription("File alive time after there is no data reference to it.");
    public static final ConfigOption<Long> FILE_DELETION_CHECK_INTERVAL = ConfigOptions.key((String)GeminiOptions.buildKey("file.deletion.check.interval.ms")).defaultValue((Object)20000L).withDescription("Interval to check whether files should be deleted.");
    public static final ConfigOption<Integer> FILE_FAIL_COUNT_THRESHOLD = ConfigOptions.key((String)GeminiOptions.buildKey("file.fail-count.threshold")).defaultValue((Object)3).withDescription("Threshold of all file writers failed count, after exceeding the threshold we will not create new file writer in a duration.");
    public static final ConfigOption<Integer> FILE_RETRY_INTERVAL = ConfigOptions.key((String)GeminiOptions.buildKey("file.retry.interval.second")).defaultValue((Object)3600).withDescription("Interval will retry to create new file writer after disabling create new file writer because ofexceed the threshold of file fail count threshold.");
    public static final ConfigOption<Integer> WRITER_FAIL_COUNT_THRESHOLD = ConfigOptions.key((String)GeminiOptions.buildKey("writer.fail-count.threshold")).defaultValue((Object)5).withDescription("File write will be invalid if number of write failures exceeds this threshold.");
    public static final ConfigOption<Integer> FILE_CLEAN_THREAD_NUM = ConfigOptions.key((String)GeminiOptions.buildKey("file.clean.thread.num")).defaultValue((Object)1).withDescription("Number of threads to clean useless files, and only one thread is supported currently.");
    public static final ConfigOption<Long> FILE_CLEAN_CHECK_INTERVAL = ConfigOptions.key((String)GeminiOptions.buildKey("file.clean.check.interval.ms")).defaultValue((Object)60000L).withDescription("Interval to check whether there are files to clean.");
    public static final ConfigOption<String> PAGE_FLUSH_LOCAL_COMPRESSION = ConfigOptions.key((String)GeminiOptions.buildKey("page.flush.local.compression")).defaultValue((Object)"None").withDescription("Compression used when flushing pages to local files.");
    public static final ConfigOption<String> PAGE_FLUSH_DFS_COMPRESSION = ConfigOptions.key((String)GeminiOptions.buildKey("page.flush.dfs.compression")).defaultValue((Object)"Lz4").withDescription("Compression used when flushing pages to dfs files.");
    public static final ConfigOption<String> IN_PAGE_COMPRESSION = ConfigOptions.key((String)GeminiOptions.buildKey("compression.in.page")).defaultValue((Object)"None").withDescription("Compression used for in-memory pages.");
    public static final ConfigOption<Integer> WHOLE_PAGE_COMPRESS_THRESHOLD = ConfigOptions.key((String)GeminiOptions.buildKey("page.compress.threshold")).defaultValue((Object)1024).withDescription("Threshold of page size to decide whether to compress page when flushing to local or dfs files");
    public static final ConfigOption<Float> PAGE_SIZE_RATE_BETWEEN_POJO_HEAP = ConfigOptions.key((String)GeminiOptions.buildKey("pojo.memory.estimate.ratio")).defaultValue((Object)Float.valueOf(10.0f)).withDescription("Ratio of size between a pojo and it's serialized binary.");
    public static final ConfigOption<Boolean> DATA_PAGE_ALLOW_MAP_SPLIT_SWITCH = ConfigOptions.key((String)GeminiOptions.buildKey("page.allow.map.split")).defaultValue((Object)true).withDescription("Whether to enable map split.");
    public static final ConfigOption<Integer> MAP_SPLIT_THRESHOLD_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("page.map.split.size.threshold")).defaultValue((Object)8192).withDescription("Threshold of map size to trigger a split.");
    public static final ConfigOption<Integer> MAP_SPLIT_SUB_MAP_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("page.map.split.sub.map.size")).defaultValue((Object)-1).withDescription("Sub-map size after splitting. -1 indicates that it will be half of " + MAP_SPLIT_THRESHOLD_SIZE.key() + ".");
    public static final ConfigOption<String> FILE_CACHE_TYPE = ConfigOptions.key((String)GeminiOptions.buildKey("file.cache.type")).defaultValue((Object)FileCache.FileCacheType.INFINITE.name()).withDescription("Type of file cache to use. " + FileCache.FileCacheType.NONE.name() + " indicates that do not use file cache, " + FileCache.FileCacheType.INFINITE.name() + " indicates cache has infinite capacity, and " + FileCache.FileCacheType.LIMITED.name() + " indicates the capacity of file is limited");
    public static final ConfigOption<String> FILE_CACHE_CAPACITY = ConfigOptions.key((String)GeminiOptions.buildKey("file.cache.capacity")).noDefaultValue().withDescription("Capacity of file cache. This option is useful only when type of file cache type is LIMITED, and will be ignored in other types");
    public static final ConfigOption<Boolean> FILE_COMPACTION = ConfigOptions.key((String)GeminiOptions.buildKey("file.compaction")).defaultValue((Object)false).withDescription("Option whether file compaction is enabled.");
    public static final ConfigOption<Float> FILE_COMPACTION_TRIGGER_RATIO = ConfigOptions.key((String)GeminiOptions.buildKey("file.compaction.trigger.ratio")).defaultValue((Object)Float.valueOf(4.0f)).withDescription("A compaction process will be triggered when amplification reaches this ratio");
    public static final ConfigOption<Float> FILE_COMPACTION_TARGET_RATIO = ConfigOptions.key((String)GeminiOptions.buildKey("file.compaction.target.ratio")).defaultValue((Object)Float.valueOf(2.0f)).withDescription("A compaction process will exit when amplification reduces to this ratio");
    public static final ConfigOption<Long> FILE_AMPLIFICATION_CHECK_INTERVAL_MS = ConfigOptions.key((String)GeminiOptions.buildKey("file.amplification.check.interval.ms")).defaultValue((Object)120000L).withDescription("Interval in milliseconds to check the space amplification periodically.");
    public static final ConfigOption<Integer> SNAPSHOT_THREAD_NUM = ConfigOptions.key((String)GeminiOptions.buildKey("snapshot.thread.num")).defaultValue((Object)3).withDescription("Number of threads used to flush pages to dfs for a snapshot.");
    public static final ConfigOption<Boolean> SNAPSHOT_COMPACTION = ConfigOptions.key((String)GeminiOptions.buildKey("snapshot.compaction")).defaultValue((Object)true).withDescription("Option whether snapshot compaction is enabled.");
    public static final ConfigOption<Float> SNAPSHOT_COMPACTION_TARGET_RATIO = ConfigOptions.key((String)GeminiOptions.buildKey("snapshot.compaction.target.ratio")).defaultValue((Object)Float.valueOf(2.0f)).withDescription("The snapshot amplification should be no more than this ratio.");
    public static final ConfigOption<Integer> SNAPSHOT_BATCH_FLUSH_NUM_PAGE = ConfigOptions.key((String)GeminiOptions.buildKey("snapshot.batch.flush.num.page")).defaultValue((Object)10).withDescription("Number of pages in a batch to flush to DFS.");
    public static final ConfigOption<String> SNAPSHOT_BATCH_FLUSH_DATA_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("snapshot.batch.flush.data.size")).defaultValue((Object)"64kb").withDescription("Size of data in a batch to flush to DFS. It works together with " + SNAPSHOT_BATCH_FLUSH_NUM_PAGE.key() + " to decide when to flush batch to DFS.");
    public static final ConfigOption<Boolean> SNAPSHOT_SYNC_WHEN_BATCH_FLUSH = ConfigOptions.key((String)GeminiOptions.buildKey("snapshot.sync.when.batch.flush")).defaultValue((Object)false).withDescription("Whether to sync when batch flush.");
    public static final ConfigOption<Boolean> RESTORE_FETCH_FILES = ConfigOptions.key((String)GeminiOptions.buildKey("restore.pre-fetch-files")).defaultValue((Object)false).withDescription("Flag indicates whether Gemini should prefetch all files when restoring without local-recovery or first download.");
    public static final ConfigOption<Integer> FETCH_FILES_THREAD_NUM = ConfigOptions.key((String)GeminiOptions.buildKey("restore.thread.num")).defaultValue((Object)2).withDescription("The number of threads used to download files from DFS, only take effect when '" + RESTORE_FETCH_FILES.key() + "' is enabled.");
    public static final ConfigOption<Long> TTL = ConfigOptions.key((String)GeminiOptions.buildKey("ttl.ms")).defaultValue((Object)-1L).withDescription("Time to live of state.");
    public static final ConfigOption<String> COMPARATOR_TYPE = ConfigOptions.key((String)GeminiOptions.buildKey("comparator.type")).defaultValue((Object)"bytes").withDescription("Comparator type for SortedMapState. bytes indicates to use comparator based on byte order, and user indicates a java comparator.");
    public static final ConfigOption<Boolean> READ_COPY = ConfigOptions.key((String)GeminiOptions.buildKey("read.copy")).defaultValue((Object)true).withDescription("Whether to copy state when reading from write buffer.");
    public static final ConfigOption<Boolean> WRITE_COPY = ConfigOptions.key((String)GeminiOptions.buildKey("write.copy")).defaultValue((Object)true).withDescription("Whether to copy state for state write");
    public static final ConfigOption<Long> THREAD_SLEEP_TIME_NS = ConfigOptions.key((String)GeminiOptions.buildKey("thread.sleep.ns")).defaultValue((Object)1000000L).withDescription("Used in GeminiEventExecutor to decide the interval to poll task queue.");
    public static final ConfigOption<Boolean> PREFETCH_ENABLE = ConfigOptions.key((String)GeminiOptions.buildKey("prefetch.enable")).defaultValue((Object)true).withDescription("Whether to enable prefetch");
    public static final ConfigOption<Long> PREFETCH_THREAD_SLEEP_TIME_NS = ConfigOptions.key((String)GeminiOptions.buildKey("prefetch.sleep.ns")).defaultValue((Object)50L).withDescription("Interval to poll tasks for prefetch event executor.");
    public static final ConfigOption<Boolean> CHECKSUM_ENABLE = ConfigOptions.key((String)GeminiOptions.buildKey("checksum.enable")).defaultValue((Object)true).withDescription("Whether to enable checksum.");
    public static final ConfigOption<Integer> PERSISTENCE_BATCH_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("persistence.batch.size")).defaultValue((Object)0x400000).withDescription("the batch size when persisting page to dfs.");
    public static final ConfigOption<Integer> PERSISTENCE_FORCE_CACHE_SIZE = ConfigOptions.key((String)GeminiOptions.buildKey("persistence.force.cache.size")).defaultValue((Object)0x200000).withDescription("the size when persisting page to cache.");
    public static final ConfigOption<Integer> PERSISTENCE_MAX_RUNNING_TASK = ConfigOptions.key((String)GeminiOptions.buildKey("persistence.max.running.task")).defaultValue((Object)2).withDescription("max persistence running task number.");
    public static final ConfigOption<String> PERSISTENCE_TYPE = ConfigOptions.key((String)GeminiOptions.buildKey("persistence.type")).defaultValue((Object)"bothDfsAndSyncHugeToCache").withDescription("set persistence type: off|asyncDfs|syncHugeToCache|bothDfsAndSyncHugeToCache(default).");
    public static final ConfigOption<Float> VM_BLOOM_FILTER_MEM_RATE = ConfigOptions.key((String)GeminiOptions.buildKey("vm.bloom.filter.mem.rate")).defaultValue((Object)Float.valueOf(0.05f)).withDescription("bloom filter memory.");
    public static final ConfigOption<Boolean> VM_BLOOM_FILTER_ENABLE = ConfigOptions.key((String)GeminiOptions.buildKey("vm.bloom.filter.enable")).defaultValue((Object)false).withDescription("enable bloom filter.");

    private static String buildKey(String name) {
        return "state.backend.gemini." + name;
    }
}

