/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.runtime.state.gemini.engine.DbPageIterator;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GeminiDB;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;

public class DbPageIteratorImpl
implements DbPageIterator {
    private final GeminiDB geminiDB;
    Iterator<GTable> tableIterator;
    Iterator<GRegion> regionIterator;
    Iterator<PageAddress> pageIterator;
    private GTable table;
    private GRegion region;
    private PageAddress page;

    public DbPageIteratorImpl(GeminiDB geminiDB) {
        this.geminiDB = geminiDB;
        this.tableIterator = geminiDB.getGeminiTableMap().values().iterator();
        this.regionIterator = Collections.emptyIterator();
        this.pageIterator = Collections.emptyIterator();
        this.advance();
    }

    private void advance() {
        while (!this.pageIterator.hasNext()) {
            while (!this.regionIterator.hasNext()) {
                if (!this.tableIterator.hasNext()) {
                    this.table = null;
                    this.region = null;
                    this.page = null;
                    return;
                }
                this.table = this.tableIterator.next();
                this.regionIterator = this.table.regionIterator();
            }
            this.region = this.regionIterator.next();
            this.pageIterator = this.region.getPageStore().getPageIndex().pageIterator();
        }
        this.page = this.pageIterator.next();
    }

    @Override
    public boolean valid() {
        return this.page != null;
    }

    @Override
    public void next() {
        this.advance();
    }

    @Override
    public GTable currentTable() {
        return this.table;
    }

    @Override
    public GRegion currentRegion() {
        return this.region;
    }

    @Override
    public PageAddress currentPage() {
        return this.page;
    }
}

