/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import java.util.Objects;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.state.gemini.GeminiOptions;
import org.apache.flink.runtime.state.gemini.engine.filecache.FileCache;
import org.apache.flink.runtime.state.gemini.engine.fs.PersistenceStrategyFactory;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparatorType;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GConfiguration.class);
    private String dfsPath;
    private String localPath;
    private int metricSampleCount;
    private int metricHistogramWindowSize;
    private int flushThreadNum;
    private int snapshotThreadNum;
    private int regionThreadNum;
    private int compactionThreadNum;
    private long maxFileSize;
    private long writeBufferSize;
    private int maxCompactionThreshold;
    private int inMemoryCompactionThreshold;
    private int maxRunningMajorCompaction;
    private int maxRunningMinorCompaction;
    private float totalWriteBufferRate;
    private int totalReadPageLRUNum;
    private int numFlushingSegment;
    private float totalNumFlushingSegmentRatio;
    private int bucketNum;
    private int splitPageThreshold;
    private int hugePageThreshold;
    private long ttl;
    private GComparatorType comparatorType = GComparatorType.bytes;
    private int subTaskIndex;
    private int numParallelSubtasks;
    private String backendUID;
    private int fileCleanThreadNum;
    private long fileCleanInterval;
    private long fileAliveTimeAfterNoDataReference;
    private long fileDeletionCheckInterval;
    private boolean readCopy;
    private boolean writeCopy;
    private int writerFailCountThreshold;
    private int fileManagerFailCountThreshold;
    private int fileManagerCreateFileWriterRetryInterval;
    private boolean localSnapshotEnabled;
    private long preFetchThreadSleepTimeNs;
    private long commonThreadSleepTimeNs;
    private GCompressAlgorithm inPageCompressAlgorithm;
    private GCompressAlgorithm pageFlushLocalCompressAlgorithm;
    private GCompressAlgorithm pageFlushDfsCompressAlgorithm;
    private boolean prefetchEnable = true;
    private int allocatorDirectArena;
    private int logicTableDefaultChainLen;
    private float totalHeapLowMarkRate;
    private float totalHeapMiddleMarkRate;
    private float totalHeapHighMarkRate;
    private float pageSizeRateBetweenPOJOAndHeap;
    private long totalIndexCountHighMark;
    private long totalIndexCountLowMark;
    private boolean checksumEnable;
    private String operatorNameWithSubtask = "";
    private int minSortedListCountForFlush;
    private int maxPreparedFlushSize;
    private int evictPoolFactor;
    private int timePerTick;
    private int wholePageCompressThreshold;
    private boolean dataPageAllowMapSplit;
    private int mapSplitSizeThreshold;
    private int mapSplitSubMapSize;
    private boolean useOffheap;
    private boolean useOffheapForRead;
    private long heapSize;
    private long offheapSize;
    private float memoryRatio;
    private int numberSlots = 1;
    private FileCache.FileCacheType fileCacheType;
    private long fileCacheCapacity;
    private boolean enableFileCompaction;
    private float compactionTriggerRatio;
    private float compactionTargetRatio;
    private long amplificationCheckInterval;
    private boolean enableSnapshotCompaction;
    private float snapshotCompactionTargetRatio;
    private int snapshotFlushBatchNumPage;
    private int snapshotFlushBatchDataSize;
    private boolean snapshotSyncWhenBatchFlush;
    private boolean enableRestorePreFetch;
    private int fetchFilesThreadNum;
    private int vmPrintTick;
    private boolean vmPrintAuditInfo;
    private boolean evictBaseOnPageAddressComposite;
    private int batchPersistenceSize;
    private int forceSyncToCacheSize;
    private int maxPersistenceRunningTask;
    private PersistenceStrategyFactory.PersistenceType persistenceType;
    private int lruIntoMainCacheThreadNum;
    private int lruIntoMainCacheSleepMs;
    private boolean enableAddIntoMainWhenSplitting;
    private boolean enableLoadPageFromLRUIntoMain;
    private boolean enableLruAccessMode;
    private boolean enableEvictRegionEven;
    private float bloomFilterMemRate;
    private boolean enableBloomFilter;

    public GConfiguration() {
    }

    public GConfiguration(Configuration configuration) {
        this.load(configuration);
    }

    public boolean isEnableEvictRegionEven() {
        return this.enableEvictRegionEven;
    }

    public boolean isEnableLruAccessMode() {
        return this.enableLruAccessMode;
    }

    public void setLogicTableDefaultChainLen(int logicTableDefaultChainLen) {
        this.logicTableDefaultChainLen = logicTableDefaultChainLen;
    }

    public int getLogicTableDefaultChainLen() {
        return this.logicTableDefaultChainLen;
    }

    public int getPageIndexBucketLenDefault() {
        return this.bucketNum;
    }

    public void setPageIndexBucketLenDefault(int bucketNum) {
        this.bucketNum = bucketNum;
    }

    public float getTotalWriteBufferRate() {
        return this.totalWriteBufferRate;
    }

    public int getTotalReadPageLRUNum() {
        return this.totalReadPageLRUNum;
    }

    public void setTotalHeapLowMarkRate(float totalHeapLowMarkRate) {
        this.totalHeapLowMarkRate = totalHeapLowMarkRate;
    }

    public float getTotalHeapLowMarkRate() {
        return this.totalHeapLowMarkRate;
    }

    public void setTotalHeapMiddleMarkRate(float totalHeapMiddleMarkRate) {
        this.totalHeapMiddleMarkRate = totalHeapMiddleMarkRate;
    }

    public float getTotalHeapMiddleMarkRate() {
        return this.totalHeapMiddleMarkRate;
    }

    public void setTotalHeapHighMarkRate(float totalHeapHighMarkRate) {
        this.totalHeapHighMarkRate = totalHeapHighMarkRate;
    }

    public float getTotalHeapHighMarkRate() {
        return this.totalHeapHighMarkRate;
    }

    public void setPageSizeRateBetweenPOJOAndHeap(float pageSizeRateBetweenPOJOAndHeap) {
        this.pageSizeRateBetweenPOJOAndHeap = pageSizeRateBetweenPOJOAndHeap;
    }

    public float getPageSizeRateBetweenPOJOAndHeap() {
        return this.pageSizeRateBetweenPOJOAndHeap;
    }

    public int getSplitPageSizeThreshold() {
        return this.splitPageThreshold;
    }

    public int getHugePageSizeThreshold() {
        return this.hugePageThreshold;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBUfferSize(long writeBufferSize) {
        Preconditions.checkArgument((writeBufferSize > 0L ? 1 : 0) != 0, (Object)("Write buffer size should be positive, actual is " + writeBufferSize));
        this.writeBufferSize = writeBufferSize;
    }

    public void setTotalIndexCountHighMark(long totalIndexCountHighMark) {
        this.totalIndexCountHighMark = totalIndexCountHighMark;
    }

    public long getTotalIndexCountHighMark() {
        return this.totalIndexCountHighMark;
    }

    public void setTotalIndexCountLowMark(long totalIndexCountLowMark) {
        this.totalIndexCountLowMark = totalIndexCountLowMark;
    }

    public long getTotalIndexCountLowMark() {
        return this.totalIndexCountLowMark;
    }

    public int getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public void setDfsPath(String dfsPath) {
        this.dfsPath = (String)Preconditions.checkNotNull((Object)dfsPath);
    }

    public String getDfsPath() {
        return this.dfsPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = (String)Preconditions.checkNotNull((Object)localPath);
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setMetricSampleCount(int count) {
        this.metricSampleCount = count;
    }

    public int getMetricSampleCount() {
        return this.metricSampleCount;
    }

    public void setMetricHistogramWindowSize(int metricHistogramWindowSize) {
        this.metricHistogramWindowSize = metricHistogramWindowSize;
    }

    public String getBackendUID() {
        return this.backendUID;
    }

    public void setBackendUID(String backendUID) {
        this.backendUID = backendUID;
    }

    public void setFlushThreadNum(int flushThreadNum) {
        if (this.checkNonnegativeArgument(flushThreadNum, "The number of threads used to flush data should be larger than zero.")) {
            this.flushThreadNum = flushThreadNum;
        }
    }

    public int getFlushThreadNum() {
        return this.flushThreadNum;
    }

    public int getSnapshotThreadNum() {
        return this.snapshotThreadNum;
    }

    public void setSnapshotThreadNum(int snapshotThreadNum) {
        if (this.checkNonnegativeArgument(snapshotThreadNum, "The number of threads used to each region should be larger than zero.")) {
            this.snapshotThreadNum = snapshotThreadNum;
        }
    }

    public void setRegionThreadNum(int regionThreadNum) {
        if (this.checkNonnegativeArgument(this.snapshotThreadNum, "The number of threads used to snapshot data should be larger than zero.")) {
            this.regionThreadNum = regionThreadNum;
        }
    }

    public int getRegionThreadNum() {
        return this.regionThreadNum;
    }

    public int getMetricHistogramWindowSize() {
        return this.metricHistogramWindowSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        Preconditions.checkArgument((maxFileSize > 0L ? 1 : 0) != 0, (Object)("Max file size should be positive, actual is " + maxFileSize));
        this.maxFileSize = maxFileSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getInMemoryCompactionThreshold() {
        return this.inMemoryCompactionThreshold;
    }

    public int getMaxRunningMajorCompaction() {
        return this.maxRunningMajorCompaction;
    }

    public int getMaxRunningMinorCompaction() {
        return this.maxRunningMinorCompaction;
    }

    public void setInMemoryCompactionThreshold(int threshold) {
        this.inMemoryCompactionThreshold = threshold;
    }

    public int getNumFlushingSegment() {
        return this.numFlushingSegment;
    }

    public float getTotalNumFlushingSegmentRatio() {
        return this.totalNumFlushingSegmentRatio;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public long getTtl() {
        return this.ttl;
    }

    public GComparatorType getComparatorType() {
        return this.comparatorType;
    }

    public void setSubTaskIndex(int subTaskIndex) {
        this.subTaskIndex = subTaskIndex;
    }

    public void setNumParallelSubtasks(int numParallelSubtasks) {
        this.numParallelSubtasks = numParallelSubtasks;
    }

    public int getSubTaskIndex() {
        return this.subTaskIndex;
    }

    public int getNumParallelSubtasks() {
        return this.numParallelSubtasks;
    }

    public void setFileCleanThreadNum(int threadNum) {
        if (this.checkNonnegativeArgument(threadNum, "The number of threads used to clean files should be larger than zero.")) {
            this.fileCleanThreadNum = threadNum;
        }
    }

    public int getFileCleanThreadNum() {
        return this.fileCleanThreadNum;
    }

    public void setFileCleanInterval(long interval) {
        this.fileCleanInterval = interval;
    }

    public long getFileCleanInterval() {
        return this.fileCleanInterval;
    }

    public void setFileAliveTimeAfterNoDataReference(long aliveTime) {
        this.fileAliveTimeAfterNoDataReference = aliveTime;
    }

    public long getFileAliveTimeAfterNoDataReference() {
        return this.fileAliveTimeAfterNoDataReference;
    }

    public void setFileDeletionCheckInterval(long interval) {
        this.fileDeletionCheckInterval = interval;
    }

    public long getFileDeletionCheckInterval() {
        return this.fileDeletionCheckInterval;
    }

    public boolean isReadCopy() {
        return this.readCopy;
    }

    public boolean isWriteCopy() {
        return this.writeCopy;
    }

    public int getWriterFailCountThreshold() {
        return this.writerFailCountThreshold;
    }

    public void setWriterFailCountThreshold(int writerFailCountThreshold) {
        this.writerFailCountThreshold = writerFailCountThreshold;
    }

    public int getFileManagerFailCountThreshold() {
        return this.fileManagerFailCountThreshold;
    }

    public void setFileManagerFailCountThreshold(int fileManagerFailCountThreshold) {
        this.fileManagerFailCountThreshold = fileManagerFailCountThreshold;
    }

    public int getFileManagerCreateFileWriterRetryInterval() {
        return this.fileManagerCreateFileWriterRetryInterval;
    }

    public void setFileManagerCreateFileWriterRetryInterval(int fileManagerCreateFileWriterRetryInterval) {
        this.fileManagerCreateFileWriterRetryInterval = fileManagerCreateFileWriterRetryInterval;
    }

    private void load(Configuration configuration) {
        this.metricSampleCount = configuration.getInteger(GeminiOptions.SAMPLE_COUNT);
        this.metricHistogramWindowSize = configuration.getInteger(GeminiOptions.HISTOGRAM_WINDOW_SIZE);
        this.flushThreadNum = configuration.getInteger(GeminiOptions.FLUSH_THREAD_NUM);
        this.snapshotThreadNum = configuration.getInteger(GeminiOptions.SNAPSHOT_THREAD_NUM);
        this.regionThreadNum = configuration.getInteger(GeminiOptions.REGION_THREAD_NUM);
        long fileSize = MemorySize.parseBytes((String)configuration.getString(GeminiOptions.MAX_FILE_SIZE));
        this.setMaxFileSize(fileSize);
        long writeBufferSize = MemorySize.parseBytes((String)configuration.getString(GeminiOptions.WRITE_BUFFER_SIZE));
        this.setWriteBUfferSize(writeBufferSize);
        this.compactionThreadNum = configuration.getInteger(GeminiOptions.COMPACTION_THREAD_NUM);
        this.maxCompactionThreshold = configuration.getInteger(GeminiOptions.MAJOR_COMPACTION_THRESHOLD);
        this.inMemoryCompactionThreshold = configuration.getInteger(GeminiOptions.MINOR_COMPACTION_THRESHOLD);
        this.maxRunningMajorCompaction = configuration.getInteger(GeminiOptions.MAJOR_COMPACTION_MAX_RUNNING);
        this.maxRunningMinorCompaction = configuration.getInteger(GeminiOptions.MINOR_COMPACTION_MAX_RUNNING);
        this.useOffheap = configuration.getBoolean(GeminiOptions.USE_OFFHEAP);
        this.totalWriteBufferRate = configuration.getFloat(GeminiOptions.TOTAL_WRITEBUFFER_RATE);
        this.totalReadPageLRUNum = configuration.getInteger(GeminiOptions.READ_LRU_SIZE);
        this.numFlushingSegment = configuration.getInteger(GeminiOptions.FLUSHING_SEGMENT);
        this.totalNumFlushingSegmentRatio = configuration.getFloat(GeminiOptions.FLUSHING_SEGMENT_RATIO);
        this.bucketNum = configuration.getInteger(GeminiOptions.BUCKET_INIT_NUM);
        this.splitPageThreshold = configuration.getInteger(GeminiOptions.SPLIT_SIZE_THRESHOLD);
        int hugeThreshold = configuration.getInteger(GeminiOptions.HUGE_PAGE_THRESHOLD);
        if (hugeThreshold < 10 * this.splitPageThreshold) {
            hugeThreshold = 10 * this.splitPageThreshold;
        }
        this.hugePageThreshold = hugeThreshold;
        this.ttl = configuration.getLong(GeminiOptions.TTL);
        this.fileCleanInterval = configuration.getLong(GeminiOptions.FILE_CLEAN_CHECK_INTERVAL);
        this.fileCleanThreadNum = configuration.getInteger(GeminiOptions.FILE_CLEAN_THREAD_NUM);
        this.fileAliveTimeAfterNoDataReference = configuration.getLong(GeminiOptions.FILE_ALIVE_TIME_AFTER_NO_DATA_REFERENCE);
        this.fileDeletionCheckInterval = configuration.getLong(GeminiOptions.FILE_DELETION_CHECK_INTERVAL);
        this.comparatorType = GComparatorType.getComparatorType(configuration.getString(GeminiOptions.COMPARATOR_TYPE));
        this.readCopy = configuration.getBoolean(GeminiOptions.READ_COPY);
        this.writeCopy = configuration.getBoolean(GeminiOptions.WRITE_COPY);
        this.writerFailCountThreshold = configuration.getInteger(GeminiOptions.WRITER_FAIL_COUNT_THRESHOLD);
        this.fileManagerFailCountThreshold = configuration.getInteger(GeminiOptions.FILE_FAIL_COUNT_THRESHOLD);
        this.fileManagerCreateFileWriterRetryInterval = configuration.getInteger(GeminiOptions.FILE_RETRY_INTERVAL);
        this.preFetchThreadSleepTimeNs = configuration.getLong(GeminiOptions.PREFETCH_THREAD_SLEEP_TIME_NS);
        this.commonThreadSleepTimeNs = configuration.getLong(GeminiOptions.THREAD_SLEEP_TIME_NS);
        this.wholePageCompressThreshold = configuration.getInteger(GeminiOptions.WHOLE_PAGE_COMPRESS_THRESHOLD);
        this.prefetchEnable = configuration.getBoolean(GeminiOptions.PREFETCH_ENABLE);
        this.allocatorDirectArena = configuration.getInteger(GeminiOptions.ALLOCATOR_DIRECT_ARENA);
        this.logicTableDefaultChainLen = configuration.getInteger(GeminiOptions.LOGIC_CHAIN_INIT_LEN);
        this.totalHeapLowMarkRate = configuration.getFloat(GeminiOptions.TOTAL_HEAP_LOW_MARK_RATE);
        this.totalHeapMiddleMarkRate = configuration.getFloat(GeminiOptions.TOTAL_HEAP_MIDDLE_MARK_RATE);
        this.totalHeapHighMarkRate = configuration.getFloat(GeminiOptions.TOTAL_HEAP_HIGH_MARK_RATE);
        this.pageSizeRateBetweenPOJOAndHeap = configuration.getFloat(GeminiOptions.PAGE_SIZE_RATE_BETWEEN_POJO_HEAP);
        this.totalIndexCountHighMark = configuration.getInteger(GeminiOptions.INDEX_COUNT_HIGH_MARK);
        this.totalIndexCountLowMark = configuration.getInteger(GeminiOptions.INDEX_COUNT_LOW_MARK);
        this.checksumEnable = configuration.getBoolean(GeminiOptions.CHECKSUM_ENABLE);
        this.minSortedListCountForFlush = configuration.getInteger(GeminiOptions.SORTED_LIST_COUNT_FOR_FLUSH);
        this.maxPreparedFlushSize = configuration.getInteger(GeminiOptions.MAX_PREPARED_FLUSH_SIZE);
        int factor = configuration.getInteger(GeminiOptions.EVICT_POOL_FACTOR);
        if (factor < 2) {
            factor = 2;
        }
        this.evictPoolFactor = factor;
        this.timePerTick = configuration.getInteger(GeminiOptions.CACHE_TIME_PER_TICK);
        this.setUseOffheap(configuration.getBoolean(GeminiOptions.USE_OFFHEAP));
        this.setUseOffheapForRead(configuration.getBoolean(GeminiOptions.USE_OFFHEAP_FOR_READ));
        String heapSizeStr = configuration.getString(GeminiOptions.HEAP_SIZE);
        this.setHeapSize(heapSizeStr != null ? this.parsePositiveBytes(heapSizeStr) : -1L);
        String offHeapSizeStr = configuration.getString(GeminiOptions.OFFHEAP_SIZE);
        this.setOffheapSize(offHeapSizeStr != null ? this.parsePositiveBytes(offHeapSizeStr) : -1L);
        this.setMemoryRatio(configuration.getFloat(GeminiOptions.MEMORY_RATIO));
        this.pageFlushDfsCompressAlgorithm = GCompressAlgorithm.getCompressAlgorithm(configuration.getString(GeminiOptions.PAGE_FLUSH_DFS_COMPRESSION), configuration);
        this.pageFlushLocalCompressAlgorithm = GCompressAlgorithm.getCompressAlgorithm(configuration.getString(GeminiOptions.PAGE_FLUSH_LOCAL_COMPRESSION), configuration);
        this.inPageCompressAlgorithm = GCompressAlgorithm.getCompressAlgorithm(configuration.getString(GeminiOptions.IN_PAGE_COMPRESSION), configuration);
        FileCache.FileCacheType fileCacheType = FileCache.FileCacheType.valueOf(configuration.getString(GeminiOptions.FILE_CACHE_TYPE));
        this.setFileCacheType(fileCacheType);
        if (fileCacheType == FileCache.FileCacheType.LIMITED) {
            long fileCacheCapacity = MemorySize.parseBytes((String)configuration.getString(GeminiOptions.FILE_CACHE_CAPACITY));
            this.setFileCacheCapacity(fileCacheCapacity);
        }
        this.dataPageAllowMapSplit = configuration.getBoolean(GeminiOptions.DATA_PAGE_ALLOW_MAP_SPLIT_SWITCH);
        this.mapSplitSizeThreshold = configuration.getInteger(GeminiOptions.MAP_SPLIT_THRESHOLD_SIZE);
        int confMapSplitSubMapSize = configuration.getInteger(GeminiOptions.MAP_SPLIT_SUB_MAP_SIZE);
        this.mapSplitSubMapSize = confMapSplitSubMapSize == -1 ? this.mapSplitSizeThreshold / 2 : confMapSplitSubMapSize;
        this.enableFileCompaction = configuration.getBoolean(GeminiOptions.FILE_COMPACTION);
        this.compactionTriggerRatio = configuration.getFloat(GeminiOptions.FILE_COMPACTION_TRIGGER_RATIO);
        this.compactionTargetRatio = configuration.getFloat(GeminiOptions.FILE_COMPACTION_TARGET_RATIO);
        this.amplificationCheckInterval = configuration.getLong(GeminiOptions.FILE_AMPLIFICATION_CHECK_INTERVAL_MS);
        this.enableSnapshotCompaction = configuration.getBoolean(GeminiOptions.SNAPSHOT_COMPACTION);
        this.snapshotCompactionTargetRatio = configuration.getFloat(GeminiOptions.SNAPSHOT_COMPACTION_TARGET_RATIO);
        this.snapshotFlushBatchNumPage = configuration.getInteger(GeminiOptions.SNAPSHOT_BATCH_FLUSH_NUM_PAGE);
        this.snapshotFlushBatchDataSize = (int)this.parsePositiveBytes(configuration.getString(GeminiOptions.SNAPSHOT_BATCH_FLUSH_DATA_SIZE));
        this.snapshotSyncWhenBatchFlush = configuration.getBoolean(GeminiOptions.SNAPSHOT_SYNC_WHEN_BATCH_FLUSH);
        this.enableRestorePreFetch = configuration.getBoolean(GeminiOptions.RESTORE_FETCH_FILES);
        this.fetchFilesThreadNum = configuration.getInteger(GeminiOptions.FETCH_FILES_THREAD_NUM);
        this.vmPrintTick = configuration.getInteger(GeminiOptions.VM_PRINT_TICK);
        if (this.vmPrintTick < 30) {
            this.vmPrintTick = 30;
        }
        this.vmPrintAuditInfo = configuration.getBoolean(GeminiOptions.VM_PRINT_AUDIT_INFO);
        this.evictBaseOnPageAddressComposite = configuration.getBoolean(GeminiOptions.VM_EVICT_BASE_ON_COMPOSITE_PAGE_ADDRESS);
        this.batchPersistenceSize = configuration.getInteger(GeminiOptions.PERSISTENCE_BATCH_SIZE);
        this.forceSyncToCacheSize = configuration.getInteger(GeminiOptions.PERSISTENCE_FORCE_CACHE_SIZE);
        this.maxPersistenceRunningTask = configuration.getInteger(GeminiOptions.PERSISTENCE_MAX_RUNNING_TASK);
        this.persistenceType = PersistenceStrategyFactory.PersistenceType.getPersistenceType(configuration.getString(GeminiOptions.PERSISTENCE_TYPE));
        this.lruIntoMainCacheThreadNum = configuration.getInteger(GeminiOptions.LRU_INTO_MAIN_CACHE_THREAD_NUM);
        this.lruIntoMainCacheSleepMs = configuration.getInteger(GeminiOptions.LRU_INTO_MAIN_CACHE_SLEEP_MS);
        this.enableAddIntoMainWhenSplitting = configuration.getBoolean(GeminiOptions.LRU_ADD_INTO_MAIN_WHEN_SPLITTING);
        this.enableLoadPageFromLRUIntoMain = configuration.getBoolean(GeminiOptions.ENABLE_LRU_INTO_MAIN_CACHE);
        this.enableLruAccessMode = configuration.getBoolean(GeminiOptions.ENABLE_LRU_ACCESS_MODE);
        this.enableEvictRegionEven = configuration.getBoolean(GeminiOptions.LRU_CACHE_EVEN_EVICT);
        this.bloomFilterMemRate = configuration.getFloat(GeminiOptions.VM_BLOOM_FILTER_MEM_RATE);
        this.enableBloomFilter = configuration.getBoolean(GeminiOptions.VM_BLOOM_FILTER_ENABLE);
    }

    public boolean isEnableLoadPageFromLRUIntoMain() {
        return this.enableLoadPageFromLRUIntoMain;
    }

    public boolean isEnableAddIntoMainWhenSplitting() {
        return this.enableAddIntoMainWhenSplitting;
    }

    public int getLruIntoMainCacheSleepMs() {
        return this.lruIntoMainCacheSleepMs;
    }

    public int getLruIntoMainCacheThreadNum() {
        return this.lruIntoMainCacheThreadNum;
    }

    public int getCompactionThreadNum() {
        return this.compactionThreadNum;
    }

    public void setLocalSnapshot(boolean enableLocalSnapshot) {
        this.localSnapshotEnabled = enableLocalSnapshot;
    }

    public boolean isLocalSnapshotEnabled() {
        return this.localSnapshotEnabled;
    }

    public long getFetchThreadSleepTimeNS() {
        return this.preFetchThreadSleepTimeNs;
    }

    public long getCommonThreadSleepTimeNs() {
        return this.commonThreadSleepTimeNs;
    }

    public GCompressAlgorithm getInPageGCompressAlgorithm() {
        return this.inPageCompressAlgorithm;
    }

    public GCompressAlgorithm getPageFlushLocalCompressAlgorithm() {
        return this.pageFlushLocalCompressAlgorithm;
    }

    public int getWholePageCompressThreshold() {
        return this.wholePageCompressThreshold;
    }

    public GCompressAlgorithm getPageFlushDfsCompressAlgorithm() {
        return this.pageFlushDfsCompressAlgorithm;
    }

    public boolean getEnablePrefetch() {
        return this.prefetchEnable;
    }

    public int getAllocatorDirectArena() {
        return this.allocatorDirectArena;
    }

    public boolean isChecksumEnable() {
        return this.checksumEnable;
    }

    public void setOperatorNameWithSubtask(String operatorNameWithSubtask) {
        this.operatorNameWithSubtask = operatorNameWithSubtask;
    }

    public String getOperatorNameWithSubtask() {
        return this.operatorNameWithSubtask;
    }

    public String getExecutorPrefixName() {
        return this.operatorNameWithSubtask == null || this.operatorNameWithSubtask.isEmpty() ? "" : this.operatorNameWithSubtask + "-";
    }

    public int getMinSortedListCountForFlush() {
        return this.minSortedListCountForFlush;
    }

    public int getTimePerTick() {
        return this.timePerTick;
    }

    public int getMaxPreparedFlushSize() {
        return this.maxPreparedFlushSize;
    }

    public int getEvictPoolFactor() {
        return this.evictPoolFactor;
    }

    public boolean isUseOffheap() {
        return this.useOffheap;
    }

    public void setUseOffheap(boolean useOffheap) {
        this.useOffheap = useOffheap;
    }

    public boolean isUseOffheapForRead() {
        return this.useOffheapForRead;
    }

    public void setUseOffheapForRead(boolean useOffheapForRead) {
        this.useOffheapForRead = useOffheapForRead;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public void setHeapSize(long heapSize) {
        this.heapSize = heapSize;
    }

    public long getOffheapSize() {
        return this.offheapSize;
    }

    public void setOffheapSize(long offheapSize) {
        this.offheapSize = offheapSize;
    }

    public float getMemoryRatio() {
        return this.memoryRatio;
    }

    public void setMemoryRatio(float memoryRatio) {
        Preconditions.checkArgument((memoryRatio >= 0.0f && memoryRatio <= 1.0f ? 1 : 0) != 0, (Object)("Memory ratio must be in [0.0, 1.0], but actual is " + memoryRatio));
        this.memoryRatio = memoryRatio;
    }

    public void setNumberSlots(int numberSlots) {
        if (numberSlots <= 1) {
            numberSlots = 1;
        }
        this.numberSlots = numberSlots;
    }

    public int getNumberSlots() {
        return this.numberSlots;
    }

    public boolean getAllowMapSplit() {
        return this.dataPageAllowMapSplit;
    }

    public void setAllowMapSplit(boolean allow) {
        this.dataPageAllowMapSplit = allow;
    }

    public int getMapSplitSizeThreshold() {
        return this.mapSplitSizeThreshold;
    }

    public void setMapSplitSizeThreshold(int threshold) {
        this.mapSplitSizeThreshold = threshold;
    }

    public int getMapSplitSubMapSize() {
        return this.mapSplitSubMapSize;
    }

    public void setMapSplitSubMapSize(int subMapSize) {
        this.mapSplitSubMapSize = subMapSize;
    }

    public void setFileCacheType(FileCache.FileCacheType type) {
        this.fileCacheType = type;
    }

    public FileCache.FileCacheType getFileCacheType() {
        return this.fileCacheType;
    }

    public void setFileCacheCapacity(long fileCacheCapacity) {
        Preconditions.checkArgument((fileCacheCapacity >= 0L ? 1 : 0) != 0, (Object)("Capacity of file cache should be non-negative, actual is " + fileCacheCapacity));
        this.fileCacheCapacity = fileCacheCapacity;
    }

    public long getFileCacheCapacity() {
        return this.fileCacheCapacity;
    }

    public void setFileCompaction(boolean enable) {
        this.enableFileCompaction = enable;
    }

    public boolean isFileCompactionEnabled() {
        return this.enableFileCompaction;
    }

    public void setCompactionTriggerRatio(float ratio) {
        this.compactionTriggerRatio = ratio;
    }

    public float getCompactionTriggerRatio() {
        return this.compactionTriggerRatio;
    }

    public void setCompactionTargetRatio(float ratio) {
        this.compactionTargetRatio = ratio;
    }

    public float getCompactionTargetRatio() {
        return this.compactionTargetRatio;
    }

    public void setAmplificationCheckInterval(long interval) {
        this.amplificationCheckInterval = interval;
    }

    public long getAmplificationCheckInterval() {
        return this.amplificationCheckInterval;
    }

    public void setSnapshotCompaction(boolean enable) {
        this.enableSnapshotCompaction = enable;
    }

    public boolean isSnapshotCompactionEnabled() {
        return this.enableSnapshotCompaction;
    }

    public void setSnapshotCompactionTargetRatio(float ratio) {
        this.snapshotCompactionTargetRatio = ratio;
    }

    public float getSnapshotCompactionTargetRatio() {
        return this.snapshotCompactionTargetRatio;
    }

    public boolean isEnableRestorePreFetch() {
        return this.enableRestorePreFetch;
    }

    public int getSnapshotFlushBatchNumPage() {
        return this.snapshotFlushBatchNumPage;
    }

    public void setSnapshotFlushBatchNumPage(int snapshotFlushBatchNumPage) {
        this.snapshotFlushBatchNumPage = snapshotFlushBatchNumPage;
    }

    public int getSnapshotFlushBatchDataSize() {
        return this.snapshotFlushBatchDataSize;
    }

    public void setSnapshotFlushBatchDataSize(int snapshotFlushBatchDataSize) {
        this.snapshotFlushBatchDataSize = snapshotFlushBatchDataSize;
    }

    public boolean isSnapshotSyncWhenBatchFlush() {
        return this.snapshotSyncWhenBatchFlush;
    }

    public void setSnapshotSyncWhenBatchFlush(boolean snapshotSyncWhenBatchFlush) {
        this.snapshotSyncWhenBatchFlush = snapshotSyncWhenBatchFlush;
    }

    public void setEnableRestorePreFetch(boolean enableRestorePreFetch) {
        this.enableRestorePreFetch = enableRestorePreFetch;
    }

    public void setFetchFilesThreadNum(int fetchFilesThreadNum) {
        Preconditions.checkArgument((fetchFilesThreadNum > 0 ? 1 : 0) != 0, (Object)"The number of threads used to download files from DFS should be larger than zero.");
        this.fetchFilesThreadNum = fetchFilesThreadNum;
    }

    public int getFetchFilesThreadNum() {
        return this.fetchFilesThreadNum;
    }

    private boolean checkNonnegativeArgument(int argumentValue, String errorMessage) {
        if (argumentValue <= 0) {
            LOG.warn(errorMessage + ", the field would still stay as previous value.");
            return false;
        }
        return true;
    }

    private long parsePositiveBytes(String value) {
        long size = MemorySize.parseBytes((String)value);
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0);
        return size;
    }

    public String toString() {
        return "GConfiguration={ttl=" + this.ttl + ", dfsPath=" + Objects.toString(this.dfsPath) + ", localPath=" + Objects.toString(this.localPath) + ", flushThreadNum=" + this.flushThreadNum + ", snapshotThreadNum=" + this.snapshotThreadNum + ", regionThreadNum=" + this.regionThreadNum + ", compactionThreadNum=" + this.compactionThreadNum + ", maxFileSize=" + this.maxFileSize + ", writeBufferSize=" + this.writeBufferSize + ", maxCompactionThreshold=" + this.maxCompactionThreshold + ", inMemoryCompactionThreshold=" + this.inMemoryCompactionThreshold + ", useOffheap=" + this.useOffheap + ", totalWriteBufferRate=" + this.totalWriteBufferRate + ", numFlushingSegment=" + this.numFlushingSegment + ", totalNumFlushingSegmentRatio=" + this.totalNumFlushingSegmentRatio + ", bucketNum=" + this.bucketNum + ", splitPageThreshold=" + this.splitPageThreshold + ", subTaskIndex=" + this.subTaskIndex + ", numParallelSubtasks=" + this.numParallelSubtasks + ", comparatorType=" + (Object)((Object)this.comparatorType) + ", numberSlots=" + this.numberSlots + ", readCopy=" + this.readCopy + ", writeCopy=" + this.writeCopy + ", inPageCompressAlgorithm=" + (Object)((Object)this.inPageCompressAlgorithm) + ", pageFlushLocalCompressAlgorithm=" + (Object)((Object)this.pageFlushLocalCompressAlgorithm) + ", pageFlushDfsCompressAlgorithm=" + (Object)((Object)this.pageFlushDfsCompressAlgorithm) + ", enableFileCompaction=" + this.enableFileCompaction + ", enableSnapshotCompaction=" + this.enableSnapshotCompaction + ", enableRestorePreFetch=" + this.enableRestorePreFetch + ", fileCacheType=" + (Object)((Object)this.fileCacheType) + "}";
    }

    public int geVmPrintTick() {
        return this.vmPrintTick;
    }

    public boolean geVmPrintAuditInfo() {
        return this.vmPrintAuditInfo;
    }

    public void setEvictPoolFactor(int evictPoolFactor) {
        this.evictPoolFactor = evictPoolFactor;
    }

    public boolean getEvictBaseOnPageAddressComposite() {
        return this.evictBaseOnPageAddressComposite;
    }

    public void setEvictBaseOnPageAddressComposite(boolean evictBaseOnPageAddressComposite) {
        this.evictBaseOnPageAddressComposite = evictBaseOnPageAddressComposite;
    }

    public int getBatchPersistenceSize() {
        return this.batchPersistenceSize;
    }

    public int getForceSyncToCacheSize() {
        return this.forceSyncToCacheSize;
    }

    public int getMaxPersistenceRunningTask() {
        return this.maxPersistenceRunningTask;
    }

    public PersistenceStrategyFactory.PersistenceType getPersistenceType() {
        return this.persistenceType;
    }

    public float getBloomFilterMemRate() {
        return this.bloomFilterMemRate;
    }

    public boolean isEnableBloomFilter() {
        return this.enableBloomFilter && this.bloomFilterMemRate > 0.0f;
    }
}

