/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferStats;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreStats;
import org.apache.flink.runtime.state.gemini.engine.utils.SeqIDUtils;

public class GRegionContext {
    private final String tableName;
    private final GRegionID regionId;
    private final WriteBufferStats writeBufferStats;
    private final PageStoreStats pageStoreStats;
    private GContext gContext;
    private long writeBufferWaterMark;
    private final PageSerdeFlink pageSerdeFlink;
    private volatile long lastSeqId;
    private volatile long removeAllSeqId;
    private final int hugePageSizeThreshold;
    private final Map<DataPage, DataPage> hugePageMap = new ConcurrentHashMap<DataPage, DataPage>();
    private final AtomicInteger hugePageTotalSize = new AtomicInteger(0);

    public GRegionContext(GContext gContext, String tableName, GRegionID regionId, PageSerdeFlink pageSerdeFlink) {
        this(gContext, tableName, regionId, pageSerdeFlink, 0L, 0L);
    }

    public GRegionContext(GContext gContext, String tableName, GRegionID regionId, PageSerdeFlink pageSerdeFlink, long lastSeqId, long removeAllSeqId) {
        this.tableName = tableName;
        this.gContext = gContext;
        this.pageStoreStats = new PageStoreStats(tableName + regionId, gContext.getSupervisor().getCacheManager());
        this.regionId = regionId;
        this.pageSerdeFlink = pageSerdeFlink;
        this.writeBufferWaterMark = gContext.getGConfiguration().getWriteBufferSize();
        this.lastSeqId = lastSeqId;
        this.removeAllSeqId = removeAllSeqId;
        this.writeBufferStats = new WriteBufferStats(gContext.getSupervisor().getWriteBufferManager());
        this.hugePageSizeThreshold = gContext.getGConfiguration().getHugePageSizeThreshold();
    }

    public WriteBufferStats getWriteBufferStats() {
        return this.writeBufferStats;
    }

    public PageStoreStats getPageStoreStats() {
        return this.pageStoreStats;
    }

    public GContext getGContext() {
        return this.gContext;
    }

    public void setWriteBufferWaterMark(long writeBufferWaterMark) {
        this.writeBufferWaterMark = writeBufferWaterMark;
    }

    public long getWriteBufferWaterMark() {
        return this.writeBufferWaterMark;
    }

    public PageSerdeFlink getPageSerdeFlink() {
        return this.pageSerdeFlink;
    }

    public GRegionID getRegionId() {
        return this.regionId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getLastSeqId() {
        return this.lastSeqId;
    }

    public long getNextSeqId() {
        long ts = this.gContext.getTimeProvider().currentTimestamp();
        this.lastSeqId = SeqIDUtils.nextSeqID(this.lastSeqId, ts);
        return this.lastSeqId;
    }

    public void setRemoveAllSeqId(long removeAllSeqId) {
        this.removeAllSeqId = removeAllSeqId;
    }

    public long getRemoveAllSeqId() {
        return this.removeAllSeqId;
    }

    public boolean filterState(long seqId) {
        StateFilter stateFilter = this.gContext.getStateFilter();
        return stateFilter != null && this.gContext.getStateFilter().filter(this, seqId);
    }

    public boolean isHugePage(DataPage dataPage) {
        return dataPage.getSize() >= this.hugePageSizeThreshold;
    }

    public void addHugePage(DataPage dataPage) {
        if (this.hugePageMap.put(dataPage, dataPage) == null) {
            this.hugePageTotalSize.addAndGet(dataPage.getSize());
            this.gContext.getSupervisor().getCacheManager().getCacheStats().addTotalHugePageSize(dataPage.getSize());
            this.gContext.getSupervisor().getCacheManager().getCacheStats().addTotalHugePageCount(1);
        }
    }

    public int getHugePageMapCount() {
        return this.hugePageMap.size();
    }

    public int getHugePageTotalSize() {
        return this.hugePageTotalSize.get();
    }

    public void tryToDelHugePage(DataPage dataPage) {
        if (this.hugePageMap.remove(dataPage) != null) {
            this.hugePageTotalSize.addAndGet(-dataPage.getSize());
            this.gContext.getSupervisor().getCacheManager().getCacheStats().addTotalHugePageSize(-dataPage.getSize());
            this.gContext.getSupervisor().getCacheManager().getCacheStats().addTotalHugePageCount(-1);
        }
    }
}

