/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.DbPageIterator;
import org.apache.flink.runtime.state.gemini.engine.DbPageIteratorImpl;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContextImpl;
import org.apache.flink.runtime.state.gemini.engine.dbms.Supervisor;
import org.apache.flink.runtime.state.gemini.engine.dbms.SupervisorImpl;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filter.CompositeStateFilter;
import org.apache.flink.runtime.state.gemini.engine.filter.RemoveAllStateFilter;
import org.apache.flink.runtime.state.gemini.engine.filter.TtlStateFilter;
import org.apache.flink.runtime.state.gemini.engine.metrics.CacheMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.ExceptionMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.FileCacheMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.FileCleanerMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.GeminiMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.HandlerMetrics;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.snapshot.BackendSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotResult;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompletableFuture;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.time.ProcessingTimeProvider;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiDB {
    private static final Logger LOG = LoggerFactory.getLogger(GeminiDB.class);
    private String dbName;
    private Supervisor geminiSupervisor;
    private final Object lock = new Object();
    private volatile Status geminiDBStatus = Status.INITIALIZE;
    private volatile Throwable internalError;
    private final Map<String, GTable> geminiTableMap = new ConcurrentHashMap<String, GTable>();
    private GContext gContext;
    private MetricGroup dbMetricGroup;
    private GConfiguration configuration;

    @VisibleForTesting
    public GeminiDB() {
        this.geminiDBStatus = Status.OPENED;
    }

    public GeminiDB(String dbName, GConfiguration conf, int startRegionId, int endRegionId, MetricGroup metricGroup) {
        this.dbName = (String)Preconditions.checkNotNull((Object)dbName);
        this.configuration = (GConfiguration)Preconditions.checkNotNull((Object)conf);
        this.gContext = new GContextImpl(this, startRegionId, endRegionId, conf);
        ProcessingTimeProvider timeProvider = new ProcessingTimeProvider();
        this.gContext.setTimeProvider(timeProvider);
        int sampleCount = conf.getMetricSampleCount();
        int histogramWindowSize = conf.getMetricHistogramWindowSize();
        this.dbMetricGroup = metricGroup;
        this.gContext.setDBMetricGroup(this.dbMetricGroup);
        MetricGroup fileManagerMetricGroup = this.dbMetricGroup.addGroup("fileManager");
        this.gContext.setFileManagerMetricGroup(fileManagerMetricGroup);
        GeminiMetrics geminiMetric = new GeminiMetrics(this.dbMetricGroup.addGroup("state"), sampleCount, histogramWindowSize);
        this.gContext.setGeminiMetric(geminiMetric);
        CacheMetrics cacheMetric = new CacheMetrics(this.dbMetricGroup.addGroup("cache"), sampleCount, histogramWindowSize);
        this.gContext.setCacheMetric(cacheMetric);
        HandlerMetrics handlerMetric = new HandlerMetrics(this.dbMetricGroup.addGroup("handler"), sampleCount, histogramWindowSize);
        this.gContext.setHandlerMetric(handlerMetric);
        FileCacheMetrics fileCacheMetrics = new FileCacheMetrics(this.dbMetricGroup.addGroup("fileCache"), sampleCount, histogramWindowSize);
        this.gContext.setFileCacheMetrics(fileCacheMetrics);
        FileCleanerMetrics fileCleanerMetrics = new FileCleanerMetrics(this.dbMetricGroup.addGroup("fileCleaner"), sampleCount, histogramWindowSize);
        this.gContext.setFileCleanerMetrics(fileCleanerMetrics);
        ExceptionMetrics exceptionMetrics = new ExceptionMetrics(this.dbMetricGroup.addGroup("exception"), sampleCount, histogramWindowSize);
        this.gContext.setExceptionMetrics(exceptionMetrics);
        CompositeStateFilter stateFilter = new CompositeStateFilter();
        if (this.gContext.hasTtl()) {
            stateFilter.addStateFilter(new TtlStateFilter());
        }
        stateFilter.addStateFilter(new RemoveAllStateFilter());
        this.gContext.setStateFilter(stateFilter);
        this.geminiSupervisor = new SupervisorImpl(this.gContext);
        this.gContext.setSupervisor(this.geminiSupervisor);
        handlerMetric.registerMetricsCacheStat(this.geminiSupervisor.getWriteBufferManager());
        LOG.info("GeminiDB is created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStatus(Status expected, Status target) {
        Object object = this.lock;
        synchronized (object) {
            if (expected != null && this.geminiDBStatus != expected) {
                return false;
            }
            this.geminiDBStatus = target;
            return true;
        }
    }

    public Status getStatus() {
        return this.geminiDBStatus;
    }

    public Throwable getInternalError() {
        return this.internalError;
    }

    public void setInternalError(Throwable throwable) {
        if (this.setStatus(Status.OPENED, Status.INTERNAL_ERROR)) {
            this.internalError = throwable;
        }
    }

    public synchronized void open() {
        if (!this.setStatus(Status.INITIALIZE, Status.OPENED)) {
            throw new GeminiRuntimeException("open db failed, current status is " + this.geminiDBStatus.toString());
        }
        this.geminiSupervisor.start();
        LOG.info("GeminiDB is opened");
    }

    public void startSnapshot(BackendSnapshotMeta backendSnapshotMeta) throws Exception {
        this.geminiSupervisor.startSnapshot(backendSnapshotMeta);
    }

    public Future<DBSnapshotResult> getSnapshotResult(long checkpointId) {
        CompletableFuture<DBSnapshotResult> result = new CompletableFuture<DBSnapshotResult>();
        SnapshotManager.PendingSnapshot pendingSnapshot = this.geminiSupervisor.getPendingSnapshot(checkpointId);
        SnapshotCompletableFuture snapshotCompletableFuture = pendingSnapshot.getResultFuture();
        snapshotCompletableFuture.whenCompleteAsync((sResult, throwable) -> {
            if (!this.gContext.isDBNormal()) {
                GeminiRuntimeException dbThrowable = new GeminiRuntimeException("DB is in abnormal status: " + this.geminiDBStatus.name());
                result.completeExceptionally(dbThrowable);
                this.gContext.getSupervisor().getSnapshotManager().endSnapshot(checkpointId, dbThrowable);
                return;
            }
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
                this.gContext.getSupervisor().getSnapshotManager().endSnapshot(checkpointId, (Throwable)throwable);
                return;
            }
            Throwable snapshotThrowable = null;
            DBSnapshotResult snapshotResult = null;
            try {
                snapshotResult = pendingSnapshot.getSnapshotOperation().getSnapshotResult();
            }
            catch (Exception e) {
                snapshotThrowable = e;
            }
            finally {
                try {
                    this.geminiSupervisor.getSnapshotManager().endSnapshot(checkpointId, snapshotThrowable);
                }
                catch (Exception e) {
                    snapshotThrowable = ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)snapshotThrowable);
                }
                if (snapshotThrowable == null) {
                    result.complete(snapshotResult);
                } else {
                    result.completeExceptionally(snapshotThrowable);
                }
            }
        }, (Executor)this.geminiSupervisor.getSnapshotManager().getSnapshotExecutor());
        return result;
    }

    public GTable getTableOrCreate(GTableDescription tableDescription) throws GeminiRuntimeException {
        return this.geminiTableMap.computeIfAbsent(tableDescription.getTableName(), nothing -> {
            GTable gTable = tableDescription.createTable(this.gContext);
            this.geminiSupervisor.getCacheManager().addTable(gTable);
            this.geminiSupervisor.getWriteBufferManager().addTableNum(tableDescription.getTableName());
            return gTable;
        });
    }

    public void close() {
        this.setStatus(null, Status.CLOSED);
        this.geminiSupervisor.stop();
        this.forceCleanUpPages();
        this.geminiSupervisor.close();
        LOG.info("GeminiDB is closed");
    }

    public GContext getGContext() {
        return this.gContext;
    }

    public GConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, GTable> getGeminiTableMap() {
        return this.geminiTableMap;
    }

    public DbPageIterator getDbPageIterator() {
        return new DbPageIteratorImpl(this);
    }

    private void forceCleanUpPages() {
        DbPageIterator iterator = this.getDbPageIterator();
        while (iterator.valid()) {
            PageAddress pa = iterator.currentPage();
            if (pa.hasDataPage()) {
                DataPage dataPage = pa.getDataPageNoReference();
                dataPage.release();
            }
            iterator.next();
        }
    }

    public static enum Status {
        INITIALIZE,
        OPENED,
        CLOSING,
        CLOSED,
        INTERNAL_ERROR;

    }
}

