/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryInfo.class);
    private final boolean useOffHeap;
    private final boolean useOffheapForRead;
    private final long totalHeapSize;
    private final long totalOffheapSize;

    public MemoryInfo(GConfiguration configuration) {
        this.useOffHeap = configuration.isUseOffheap();
        this.useOffheapForRead = configuration.isUseOffheapForRead();
        this.totalHeapSize = this.calculateHeapSize(configuration);
        this.totalOffheapSize = this.calculateOffheapSize(configuration);
        LOG.info(this.toString());
    }

    private long calculateHeapSize(GConfiguration configuration) {
        long heapSize = configuration.getHeapSize();
        if (heapSize > 0L) {
            return heapSize;
        }
        long jvmHeapSize = MemoryInfo.getJvmHeapSize();
        return (long)((float)(jvmHeapSize / (long)configuration.getNumberSlots()) * configuration.getMemoryRatio());
    }

    private long calculateOffheapSize(GConfiguration configuration) {
        long offheapSize = configuration.getOffheapSize();
        if (offheapSize > 0L) {
            return offheapSize;
        }
        long jvmOffheapSize = MemoryInfo.getJvmDirectMemorySize();
        return (long)((float)(jvmOffheapSize / (long)configuration.getNumberSlots()) * configuration.getMemoryRatio());
    }

    public boolean isUseOffHeap() {
        return this.useOffHeap;
    }

    public boolean isUseOffheapForRead() {
        return this.useOffheapForRead;
    }

    public long getTotalHeapSize() {
        return this.totalHeapSize;
    }

    public long getTotalOffheapSize() {
        return this.totalOffheapSize;
    }

    public static long getJvmHeapSize() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
    }

    public static long getJvmDirectMemorySize() {
        try {
            Class<?> c = Class.forName("java.nio.Bits");
            Field maxMemory = c.getDeclaredField("maxMemory");
            maxMemory.setAccessible(true);
            return (Long)maxMemory.get(null);
        }
        catch (Exception e) {
            throw new GeminiRuntimeException(e);
        }
    }

    public String toString() {
        return "MemoryInfo={useOffheap=" + this.useOffHeap + ", useOffheapForRead=" + this.useOffheapForRead + ", totalHeapSize=" + this.totalHeapSize + ", totalOffheapSize=" + this.totalOffheapSize + "}";
    }
}

