/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.filecache;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filecache.FileCacheStat;
import org.apache.flink.runtime.state.gemini.engine.filecache.InfiniteFileCache;
import org.apache.flink.runtime.state.gemini.engine.filecache.NoFileCache;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.fs.FileWriter;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddressSingleImpl;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.Preconditions;

public abstract class FileCache
implements Closeable {
    protected final long capacity;
    protected final FileCacheStat fileCacheStat;

    public FileCache(long capacity, FileCacheStat fileCacheStat) {
        this.capacity = capacity;
        this.fileCacheStat = (FileCacheStat)Preconditions.checkNotNull((Object)fileCacheStat);
    }

    public long capacity() {
        return this.capacity;
    }

    public abstract boolean isCached(PageAddress var1);

    public abstract void addPage(PageAddress var1, GRegionContext var2, EventExecutor var3, @Nullable BiConsumer<Boolean, Throwable> var4);

    public abstract GByteBuffer getPage(PageAddress var1, GRegionContext var2, EventExecutor var3);

    public abstract void discardPage(PageAddress var1, GRegionContext var2, EventExecutor var3);

    public abstract void flushPage(PageAddress var1, GRegionContext var2, EventExecutor var3, boolean var4, @Nullable BiConsumer<Boolean, Throwable> var5);

    public abstract void addBatchPages(List<PageAddress> var1, List<GRegionContext> var2, EventExecutor var3, List<BiConsumer<Boolean, Throwable>> var4);

    public abstract void flushBatchPages(List<PageAddress> var1, List<GRegionContext> var2, EventExecutor var3, boolean var4, boolean var5, List<BiConsumer<Boolean, Throwable>> var6);

    public abstract void sync() throws IOException;

    public FileCacheStat getFileCacheStat() {
        return this.fileCacheStat;
    }

    public abstract FileCacheType getFileCacheType();

    void internalAddPage(FileManager fileManager, FileWriter fileWriter, PageAddress pageAddress, GByteBuffer gByteBuffer, GRegionContext gRegionContext, boolean isLocal, boolean flushForce) throws Exception {
        long address;
        Preconditions.checkArgument((boolean)(pageAddress instanceof PageAddressSingleImpl));
        int numRetires = 0;
        while (true) {
            try {
                address = this.writePage(fileManager, fileWriter, pageAddress, gByteBuffer, gRegionContext, isLocal);
            }
            catch (Exception e) {
                fileWriter.increasFailCount();
                if (++numRetires <= 3) continue;
                throw e;
            }
            break;
        }
        if (flushForce) {
            fileWriter.flush();
        }
        this.updatePageAddress(fileManager, pageAddress, address, isLocal, gRegionContext.getGContext().getAccessNumber());
    }

    long writePage(FileManager fileManager, FileWriter fileWriter, PageAddress page, GByteBuffer buffer, GRegionContext gRegionContext, boolean isLocal) throws IOException {
        long address = fileWriter.getAddress();
        long startTime = System.nanoTime();
        int diskDataLen = fileManager.getDataPageUtil().write(fileWriter, buffer, page, gRegionContext.getGContext().getFlushWholePageGCompressAlgorithm(isLocal), gRegionContext.getGContext().getWholePageCompressThreshold(), gRegionContext.getGContext().getGConfiguration().isChecksumEnable());
        fileWriter.resetFailCount();
        this.updateWriteStat(diskDataLen, page.getDataLen(), System.nanoTime() - startTime, isLocal);
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePageAddress(FileManager fileManager, PageAddress page, long newAddress, boolean isLocal, long accessNumber) {
        boolean pageValid;
        fileManager.incDBReference(newAddress, page.getDataLen());
        boolean hasOldAddress = false;
        long oldAddress = 0L;
        PageAddress pageAddress = page;
        synchronized (pageAddress) {
            pageValid = page.isPageValid();
            if (pageValid) {
                hasOldAddress = isLocal ? page.isLocalValid() : page.isDfsValid();
                long l = oldAddress = isLocal ? page.getLocalAddress() : page.getDfsAddress();
            }
            if (isLocal) {
                page.setLocalAddress(newAddress);
                page.setLocalStatus(true);
            } else {
                page.setDfsAddress(newAddress);
                page.setDfsStatus(true);
            }
        }
        if (pageValid) {
            if (hasOldAddress) {
                fileManager.decDBReference(oldAddress, accessNumber, System.currentTimeMillis(), page.getDataLen());
            }
        } else {
            fileManager.decDBReference(newAddress, accessNumber, System.currentTimeMillis(), page.getDataLen());
        }
    }

    private void updateWriteStat(long diskLen, long size, long time, boolean isLocal) {
        if (isLocal) {
            this.fileCacheStat.addLocalWrite(diskLen, size, time);
        } else {
            this.fileCacheStat.addDFSWrite(diskLen, size, time);
        }
    }

    public static FileCache createFileCache(GContext context, FileManager localFileManager, FileManager dfsFileManager) {
        FileCache fileCache;
        GConfiguration gConfiguration = context.getGConfiguration();
        FileCacheType type = gConfiguration.getFileCacheType();
        switch (type) {
            case NONE: {
                fileCache = new NoFileCache(context, dfsFileManager);
                break;
            }
            case INFINITE: {
                fileCache = new InfiniteFileCache(context, localFileManager, dfsFileManager);
                break;
            }
            case LIMITED: {
                throw new GeminiRuntimeException("Limited file cache is not supported currently");
            }
            default: {
                throw new GeminiRuntimeException("Unknown file cache type " + (Object)((Object)type));
            }
        }
        return fileCache;
    }

    public static enum FileCacheType {
        NONE,
        INFINITE,
        LIMITED;

    }
}

