/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.filecache;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.filecache.FileCache;
import org.apache.flink.runtime.state.gemini.engine.filecache.PageBatchIO;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutorGroup;

public class PageBatchFlusher
implements PageBatchIO {
    private final int batchNumPages;
    private final int batchDataSize;
    private final FileCache fileCache;
    private final EventExecutorGroup eventExecutorGroup;
    private final boolean forceFlush;
    private List<PageAddress> pages;
    private List<GRegionContext> regionContexts;
    private List<BiConsumer<Boolean, Throwable>> callBacks;
    private int dataSize;

    public PageBatchFlusher(int numPages, int dataSize, boolean forceFlush, FileCache fileCache, EventExecutorGroup eventExecutorGroup) {
        this.batchNumPages = numPages;
        this.batchDataSize = dataSize;
        this.forceFlush = forceFlush;
        this.fileCache = fileCache;
        this.eventExecutorGroup = eventExecutorGroup;
        this.reset();
    }

    @Override
    public void addPage(PageAddress page, GRegionContext gRegionContext, BiConsumer<Boolean, Throwable> callBack) {
        this.pages.add(page);
        this.regionContexts.add(gRegionContext);
        this.callBacks.add(callBack);
        this.dataSize += page.getDataLen();
        if (this.pages.size() >= this.batchNumPages || this.dataSize >= this.batchDataSize) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        if (this.pages.isEmpty()) {
            return;
        }
        this.fileCache.flushBatchPages(this.pages, this.regionContexts, this.eventExecutorGroup.next(), this.forceFlush, true, this.callBacks);
        this.reset();
    }

    private void reset() {
        this.pages = new ArrayList<PageAddress>(this.batchNumPages);
        this.regionContexts = new ArrayList<GRegionContext>(this.batchNumPages);
        this.callBacks = new ArrayList<BiConsumer<Boolean, Throwable>>(this.batchNumPages);
        this.dataSize = 0;
    }

    public boolean isForceFlush() {
        return this.forceFlush;
    }

    public int getBatchDataSize() {
        return this.batchDataSize;
    }

    public int getBatchNumPages() {
        return this.batchNumPages;
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }

    public EventExecutorGroup getEventExecutorGroup() {
        return this.eventExecutorGroup;
    }

    @VisibleForTesting
    int getDataSize() {
        return this.dataSize;
    }

    @VisibleForTesting
    List<PageAddress> getPages() {
        return this.pages;
    }

    @VisibleForTesting
    List<GRegionContext> getRegionContexts() {
        return this.regionContexts;
    }

    @VisibleForTesting
    List<BiConsumer<Boolean, Throwable>> getCallBacks() {
        return this.callBacks;
    }
}

